/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.common.base.Preconditions;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

final class HandshakerServiceChannel {
    private static String handshakerAddress = "metadata.google.internal:8080";
    private static ManagedChannel channel = null;

    private HandshakerServiceChannel() {
    }

    public static synchronized void setHandshakerAddressForTesting(String handshakerAddress) {
        Preconditions.checkState((channel == null || HandshakerServiceChannel.handshakerAddress.equals(handshakerAddress) ? 1 : 0) != 0, (Object)"HandshakerServiceChannel already created with a different handshakerAddress");
        HandshakerServiceChannel.handshakerAddress = handshakerAddress;
        if (channel == null) {
            channel = HandshakerServiceChannel.createChannel();
        }
    }

    private static ManagedChannel createChannel() {
        DefaultThreadFactory clientThreadFactory = new DefaultThreadFactory("handshaker pool", true);
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)handshakerAddress).directExecutor()).eventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)clientThreadFactory)).usePlaintext().build();
        return channel;
    }

    public static synchronized ManagedChannel get() {
        if (channel == null) {
            channel = HandshakerServiceChannel.createChannel();
        }
        return channel;
    }
}

