/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.Grpc;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.alts.internal.AltsAuthContext;
import io.grpc.alts.internal.NettyTsiHandshaker;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiFrameHandler;
import io.grpc.alts.internal.TsiHandshakeHandler;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.internal.Channelz;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;

public abstract class AltsProtocolNegotiator
implements ProtocolNegotiator {
    private static final Attributes.Key<TsiPeer> TSI_PEER_KEY = Attributes.Key.create((String)"TSI_PEER");
    private static final Attributes.Key<AltsAuthContext> ALTS_CONTEXT_KEY = Attributes.Key.create((String)"ALTS_CONTEXT_KEY");
    private static final AsciiString scheme = AsciiString.of((CharSequence)"https");

    public static Attributes.Key<TsiPeer> getTsiPeerAttributeKey() {
        return TSI_PEER_KEY;
    }

    public static Attributes.Key<AltsAuthContext> getAltsAuthContextAttributeKey() {
        return ALTS_CONTEXT_KEY;
    }

    public static AltsProtocolNegotiator create(final TsiHandshakerFactory handshakerFactory) {
        return new AltsProtocolNegotiator(){

            public ProtocolNegotiator.Handler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                return new BufferUntilAltsNegotiatedHandler(grpcHandler, new ChannelHandler[]{new TsiHandshakeHandler(new NettyTsiHandshaker(handshakerFactory.newHandshaker())), new TsiFrameHandler()});
            }
        };
    }

    @VisibleForTesting
    static class BufferUntilAltsNegotiatedHandler
    extends ProtocolNegotiators.AbstractBufferingHandler
    implements ProtocolNegotiator.Handler {
        private final GrpcHttp2ConnectionHandler grpcHandler;

        BufferUntilAltsNegotiatedHandler(GrpcHttp2ConnectionHandler grpcHandler, ChannelHandler ... negotiationhandlers) {
            super(negotiationhandlers);
            this.grpcHandler = grpcHandler;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.fail(ctx, cause);
            ctx.fireExceptionCaught(cause);
        }

        public AsciiString scheme() {
            return scheme;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof TsiHandshakeHandler.TsiHandshakeCompletionEvent) {
                TsiHandshakeHandler.TsiHandshakeCompletionEvent altsEvt = (TsiHandshakeHandler.TsiHandshakeCompletionEvent)evt;
                if (altsEvt.isSuccess()) {
                    if (this.grpcHandler != null) {
                        ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)this.grpcHandler);
                        AltsAuthContext altsContext = (AltsAuthContext)altsEvt.context();
                        Preconditions.checkNotNull((Object)altsContext);
                        RpcProtocolVersionsUtil.RpcVersionsCheckResult checkResult = RpcProtocolVersionsUtil.checkRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions(), altsContext.getPeerRpcVersions());
                        if (!checkResult.getResult()) {
                            String errorMessage = "Local Rpc Protocol Versions " + RpcProtocolVersionsUtil.getRpcProtocolVersions().toString() + "are not compatible with peer Rpc Protocol Versions " + altsContext.getPeerRpcVersions().toString();
                            this.fail(ctx, (Throwable)Status.UNAVAILABLE.withDescription(errorMessage).asRuntimeException());
                        }
                        this.grpcHandler.handleProtocolNegotiationCompleted(Attributes.newBuilder().set(TSI_PEER_KEY, (Object)altsEvt.peer()).set(ALTS_CONTEXT_KEY, (Object)altsContext).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(CallCredentials.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).build(), new Channelz.Security(new Channelz.OtherSecurity("alts", (Object)Any.pack((Message)altsContext.context))));
                    }
                    this.writeBufferedAndRemove(ctx);
                } else {
                    this.fail(ctx, BufferUntilAltsNegotiatedHandler.unavailableException("ALTS handshake failed", altsEvt.cause()));
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        private static RuntimeException unavailableException(String msg, Throwable cause) {
            return Status.UNAVAILABLE.withCause(cause).withDescription(msg).asRuntimeException();
        }
    }
}

