/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.GoogleDefaultProtocolNegotiator;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ProxyParameters;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelBuilder
extends ForwardingChannelBuilder<GoogleDefaultChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private final TcpfFactory tcpfFactory = new TcpfFactory();

    private GoogleDefaultChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget((String)target);
        InternalNettyChannelBuilder.setDynamicTransportParamsFactory((NettyChannelBuilder)this.delegate(), (InternalNettyChannelBuilder.TransportCreationParamsFilterFactory)this.tcpfFactory);
    }

    public static final GoogleDefaultChannelBuilder forTarget(String target) {
        return new GoogleDefaultChannelBuilder(target);
    }

    public static GoogleDefaultChannelBuilder forAddress(String name, int port) {
        return GoogleDefaultChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    public ManagedChannel build() {
        CallCredentials credentials = null;
        Status status = Status.OK;
        try {
            credentials = MoreCallCredentials.from((Credentials)GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            status = Status.FAILED_PRECONDITION.withDescription("Failed to get Google default credentials").withCause((Throwable)e);
        }
        return ((NettyChannelBuilder)this.delegate().intercept(new ClientInterceptor[]{new GoogleDefaultInterceptor(credentials, status)})).build();
    }

    @VisibleForTesting
    InternalNettyChannelBuilder.TransportCreationParamsFilterFactory getTcpfFactoryForTest() {
        return this.tcpfFactory;
    }

    static final class FailingClientCall<ReqT, RespT>
    extends ClientCall<ReqT, RespT> {
        private final Status error;

        public FailingClientCall(Status error) {
            this.error = error;
        }

        public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
            listener.onClose(this.error, new Metadata());
        }

        public void request(int numMessages) {
        }

        public void cancel(String message, Throwable cause) {
        }

        public void halfClose() {
        }

        public void sendMessage(ReqT message) {
        }
    }

    static final class GoogleDefaultInterceptor
    implements ClientInterceptor {
        @Nullable
        private final CallCredentials credentials;
        private final Status status;

        public GoogleDefaultInterceptor(@Nullable CallCredentials credentials, Status status) {
            this.credentials = credentials;
            this.status = status;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (!this.status.isOk()) {
                return new FailingClientCall(this.status);
            }
            return next.newCall(method, callOptions.withCallCredentials(this.credentials));
        }
    }

    private static final class TcpfFactory
    implements InternalNettyChannelBuilder.TransportCreationParamsFilterFactory {
        private final SslContext sslContext;
        private final AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).build();
        private final TsiHandshakerFactory altsHandshakerFactory = new TsiHandshakerFactory(){

            @Override
            public TsiHandshaker newHandshaker() {
                ManagedChannel channel = HandshakerServiceChannel.get();
                return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub((Channel)channel), TcpfFactory.this.handshakerOptions);
            }
        };

        private TcpfFactory() {
            try {
                this.sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public InternalNettyChannelBuilder.TransportCreationParamsFilter create(final SocketAddress serverAddress, final String authority, final String userAgent, ProxyParameters proxy) {
            Preconditions.checkArgument((boolean)(serverAddress instanceof InetSocketAddress), (String)"%s must be a InetSocketAddress", (Object)serverAddress);
            final GoogleDefaultProtocolNegotiator negotiator = new GoogleDefaultProtocolNegotiator(this.altsHandshakerFactory, this.sslContext, authority);
            return new InternalNettyChannelBuilder.TransportCreationParamsFilter(){

                public SocketAddress getTargetServerAddress() {
                    return serverAddress;
                }

                public String getAuthority() {
                    return authority;
                }

                public String getUserAgent() {
                    return userAgent;
                }

                public GoogleDefaultProtocolNegotiator getProtocolNegotiator() {
                    return negotiator;
                }
            };
        }
    }
}

