/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.DefaultChannelPromise;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.List;

final class ProtectedPromise
extends DefaultChannelPromise {
    private final List<ChannelPromise> unprotectedPromises;
    private int expectedCount;
    private int successfulCount;
    private int failureCount;
    private boolean doneAllocating;

    ProtectedPromise(Channel channel, EventExecutor executor, int numUnprotectedPromises) {
        super(channel, executor);
        this.unprotectedPromises = new ArrayList<ChannelPromise>(numUnprotectedPromises);
    }

    void addUnprotectedPromise(ChannelPromise promise) {
        this.unprotectedPromises.add(promise);
    }

    ChannelPromise newPromise() {
        Preconditions.checkState((!this.doneAllocating ? 1 : 0) != 0, (Object)"Done allocating. No more promises can be allocated.");
        ++this.expectedCount;
        return this;
    }

    ChannelPromise doneAllocatingPromises() {
        if (!this.doneAllocating) {
            this.doneAllocating = true;
            if (this.successfulCount == this.expectedCount) {
                this.trySuccessInternal(null);
                return super.setSuccess(null);
            }
        }
        return this;
    }

    public boolean tryFailure(Throwable cause) {
        if (this.awaitingPromises()) {
            ++this.failureCount;
            if (this.failureCount == 1) {
                this.tryFailureInternal(cause);
                return super.tryFailure(cause);
            }
            return true;
        }
        return false;
    }

    public ChannelPromise setFailure(Throwable cause) {
        this.tryFailure(cause);
        return this;
    }

    private boolean awaitingPromises() {
        return this.successfulCount + this.failureCount < this.expectedCount;
    }

    public ChannelPromise setSuccess(Void result) {
        this.trySuccess(result);
        return this;
    }

    public boolean trySuccess(Void result) {
        if (this.awaitingPromises()) {
            ++this.successfulCount;
            if (this.successfulCount == this.expectedCount && this.doneAllocating) {
                this.trySuccessInternal(result);
                return super.trySuccess((Object)result);
            }
            return true;
        }
        return false;
    }

    private void trySuccessInternal(Void result) {
        for (int i = 0; i < this.unprotectedPromises.size(); ++i) {
            this.unprotectedPromises.get(i).trySuccess((Object)result);
        }
    }

    private void tryFailureInternal(Throwable cause) {
        for (int i = 0; i < this.unprotectedPromises.size(); ++i) {
            this.unprotectedPromises.get(i).tryFailure(cause);
        }
    }
}

