/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.alts.FailingClientCall;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.GoogleDefaultProtocolNegotiator;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelBuilder
extends ForwardingChannelBuilder<GoogleDefaultChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private GoogleDefaultProtocolNegotiator negotiatorForTest;

    private GoogleDefaultChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget((String)target);
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate(), (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)new ProtocolNegotiatorFactory());
        CallCredentials credentials = null;
        Status status = Status.OK;
        try {
            credentials = MoreCallCredentials.from((Credentials)GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            status = Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause((Throwable)e);
        }
        this.delegate().intercept(new ClientInterceptor[]{new GoogleDefaultInterceptor(credentials, status)});
    }

    public static final GoogleDefaultChannelBuilder forTarget(String target) {
        return new GoogleDefaultChannelBuilder(target);
    }

    public static GoogleDefaultChannelBuilder forAddress(String name, int port) {
        return GoogleDefaultChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GoogleDefaultProtocolNegotiator getProtocolNegotiatorForTest() {
        return this.negotiatorForTest;
    }

    static final class GoogleDefaultInterceptor
    implements ClientInterceptor {
        @Nullable
        private final CallCredentials credentials;
        private final Status status;

        public GoogleDefaultInterceptor(@Nullable CallCredentials credentials, Status status) {
            this.credentials = credentials;
            this.status = status;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (!this.status.isOk()) {
                return new FailingClientCall(this.status);
            }
            return next.newCall(method, callOptions.withCallCredentials(this.credentials));
        }
    }

    private final class ProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private ProtocolNegotiatorFactory() {
        }

        public GoogleDefaultProtocolNegotiator buildProtocolNegotiator() {
            SslContext sslContext;
            TsiHandshakerFactory altsHandshakerFactory = new TsiHandshakerFactory(){

                @Override
                public TsiHandshaker newHandshaker(String authority) {
                    Channel channel = (Channel)SharedResourceHolder.get(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
                    AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetName(authority).build();
                    return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(channel), handshakerOptions);
                }
            };
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException ex) {
                throw new RuntimeException(ex);
            }
            return GoogleDefaultChannelBuilder.this.negotiatorForTest = new GoogleDefaultProtocolNegotiator(altsHandshakerFactory, sslContext);
        }
    }
}

