/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.alts.internal.AltsAuthContext;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsHandshakerOptions;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.NettyTsiHandshaker;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshakeHandler;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AltsProtocolNegotiator {
    private static final Logger logger = Logger.getLogger(AltsProtocolNegotiator.class.getName());
    public static final Attributes.Key<TsiPeer> TSI_PEER_KEY = Attributes.Key.create((String)"TSI_PEER");
    public static final Attributes.Key<Object> AUTH_CONTEXT_KEY = Attributes.Key.create((String)"AUTH_CONTEXT_KEY");
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"https");

    public static InternalProtocolNegotiator.ProtocolNegotiator serverAltsProtocolNegotiator(ObjectPool<Channel> handshakerChannelPool) {
        LazyChannel lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
        final class ServerTsiHandshakerFactory
        implements TsiHandshakerFactory {
            final /* synthetic */ LazyChannel val$lazyHandshakerChannel;

            ServerTsiHandshakerFactory(LazyChannel lazyChannel) {
                this.val$lazyHandshakerChannel = lazyChannel;
            }

            @Override
            public TsiHandshaker newHandshaker(@Nullable String authority) {
                assert (authority == null);
                return AltsTsiHandshaker.newServer(HandshakerServiceGrpc.newStub(this.val$lazyHandshakerChannel.get()), new AltsHandshakerOptions(RpcProtocolVersionsUtil.getRpcProtocolVersions()));
            }
        }
        return new ServerAltsProtocolNegotiator(new ServerTsiHandshakerFactory(lazyHandshakerChannel), lazyHandshakerChannel);
    }

    private AltsProtocolNegotiator() {
    }

    private static final class AltsHandshakeValidator
    extends TsiHandshakeHandler.HandshakeValidator {
        private AltsHandshakeValidator() {
        }

        @Override
        public TsiHandshakeHandler.HandshakeValidator.SecurityDetails validatePeerObject(Object peerObject) throws GeneralSecurityException {
            AltsAuthContext altsAuthContext = (AltsAuthContext)peerObject;
            RpcProtocolVersionsUtil.RpcVersionsCheckResult checkResult = RpcProtocolVersionsUtil.checkRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions(), altsAuthContext.getPeerRpcVersions());
            if (!checkResult.getResult()) {
                String errorMessage = "Local Rpc Protocol Versions " + RpcProtocolVersionsUtil.getRpcProtocolVersions() + " are not compatible with peer Rpc Protocol Versions " + altsAuthContext.getPeerRpcVersions();
                throw Status.UNAVAILABLE.withDescription(errorMessage).asRuntimeException();
            }
            return new TsiHandshakeHandler.HandshakeValidator.SecurityDetails(SecurityLevel.PRIVACY_AND_INTEGRITY, new InternalChannelz.Security(new InternalChannelz.OtherSecurity("alts", (Object)Any.pack((Message)altsAuthContext.context))));
        }
    }

    @VisibleForTesting
    static final class LazyChannel {
        private final ObjectPool<Channel> channelPool;
        private Channel channel;

        @VisibleForTesting
        LazyChannel(ObjectPool<Channel> channelPool) {
            this.channelPool = (ObjectPool)Preconditions.checkNotNull(channelPool, (Object)"channelPool");
        }

        synchronized Channel get() {
            if (this.channel == null) {
                this.channel = (Channel)this.channelPool.getObject();
            }
            return this.channel;
        }

        synchronized void close() {
            if (this.channel != null) {
                this.channelPool.returnObject((Object)this.channel);
            }
        }
    }

    private static final class ClientTsiHandshakerFactory
    implements TsiHandshakerFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;

        ClientTsiHandshakerFactory(ImmutableList<String> targetServiceAccounts, LazyChannel lazyHandshakerChannel) {
            this.targetServiceAccounts = (ImmutableList)Preconditions.checkNotNull(targetServiceAccounts, (Object)"targetServiceAccounts");
            this.lazyHandshakerChannel = (LazyChannel)Preconditions.checkNotNull((Object)lazyHandshakerChannel, (Object)"lazyHandshakerChannel");
        }

        @Override
        public TsiHandshaker newHandshaker(@Nullable String authority) {
            AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetServiceAccounts(this.targetServiceAccounts).setTargetName(authority).build();
            return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(this.lazyHandshakerChannel.get()), handshakerOptions);
        }
    }

    private static final class GoogleDefaultProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;
        private final SslContext sslContext;

        GoogleDefaultProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel, SslContext sslContext) {
            this.handshakerFactory = (TsiHandshakerFactory)Preconditions.checkNotNull((Object)handshakerFactory, (Object)"handshakerFactory");
            this.lazyHandshakerChannel = (LazyChannel)Preconditions.checkNotNull((Object)lazyHandshakerChannel, (Object)"lazyHandshakerChannel");
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"checkNotNull");
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            Object securityHandler;
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler((GrpcHttp2ConnectionHandler)grpcHandler);
            if (grpcHandler.getEagAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) != null || grpcHandler.getEagAttributes().get(GrpcAttributes.ATTR_LB_PROVIDED_BACKEND) != null) {
                TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(grpcHandler.getAuthority());
                NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
                securityHandler = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator());
            } else {
                securityHandler = InternalProtocolNegotiators.clientTlsHandler((ChannelHandler)gnh, (SslContext)this.sslContext, (String)grpcHandler.getAuthority());
            }
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler((ChannelHandler)securityHandler);
            return wuah;
        }

        public void close() {
            logger.finest("ALTS Server ProtocolNegotiator Closed");
            this.lazyHandshakerChannel.close();
        }
    }

    public static final class GoogleDefaultProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;
        private final SslContext sslContext;

        public GoogleDefaultProtocolNegotiatorFactory(List<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool, SslContext sslContext) {
            this.targetServiceAccounts = ImmutableList.copyOf(targetServiceAccounts);
            this.lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        }

        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            return new GoogleDefaultProtocolNegotiator(new ClientTsiHandshakerFactory(this.targetServiceAccounts, this.lazyHandshakerChannel), this.lazyHandshakerChannel, this.sslContext);
        }
    }

    @VisibleForTesting
    static final class ServerAltsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;

        @VisibleForTesting
        ServerAltsProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel) {
            this.handshakerFactory = (TsiHandshakerFactory)Preconditions.checkNotNull((Object)handshakerFactory, (Object)"handshakerFactory");
            this.lazyHandshakerChannel = (LazyChannel)Preconditions.checkNotNull((Object)lazyHandshakerChannel, (Object)"lazyHandshakerChannel");
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(null);
            NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler((GrpcHttp2ConnectionHandler)grpcHandler);
            TsiHandshakeHandler thh = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator());
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler((ChannelHandler)thh);
            KickNegotiationHandler knh = new KickNegotiationHandler(wuah);
            return knh;
        }

        public void close() {
            logger.finest("ALTS Server ProtocolNegotiator Closed");
            this.lazyHandshakerChannel.close();
        }

        private static final class KickNegotiationHandler
        extends ChannelInboundHandlerAdapter {
            private final ChannelHandler next;

            KickNegotiationHandler(ChannelHandler next) {
                this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
            }

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                super.handlerAdded(ctx);
                ctx.pipeline().replace(ctx.name(), null, this.next);
                ctx.pipeline().fireUserEventTriggered((Object)InternalProtocolNegotiationEvent.getDefault());
            }
        }
    }

    private static final class ClientAltsProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final TsiHandshakerFactory handshakerFactory;
        private final LazyChannel lazyHandshakerChannel;

        ClientAltsProtocolNegotiator(TsiHandshakerFactory handshakerFactory, LazyChannel lazyHandshakerChannel) {
            this.handshakerFactory = (TsiHandshakerFactory)Preconditions.checkNotNull((Object)handshakerFactory, (Object)"handshakerFactory");
            this.lazyHandshakerChannel = (LazyChannel)Preconditions.checkNotNull((Object)lazyHandshakerChannel, (Object)"lazyHandshakerChannel");
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            TsiHandshaker handshaker = this.handshakerFactory.newHandshaker(grpcHandler.getAuthority());
            NettyTsiHandshaker nettyHandshaker = new NettyTsiHandshaker(handshaker);
            ChannelHandler gnh = InternalProtocolNegotiators.grpcNegotiationHandler((GrpcHttp2ConnectionHandler)grpcHandler);
            TsiHandshakeHandler thh = new TsiHandshakeHandler(gnh, nettyHandshaker, new AltsHandshakeValidator());
            ChannelHandler wuah = InternalProtocolNegotiators.waitUntilActiveHandler((ChannelHandler)thh);
            return wuah;
        }

        public void close() {
            this.lazyHandshakerChannel.close();
        }
    }

    public static final class ClientAltsProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private final ImmutableList<String> targetServiceAccounts;
        private final LazyChannel lazyHandshakerChannel;

        public ClientAltsProtocolNegotiatorFactory(List<String> targetServiceAccounts, ObjectPool<Channel> handshakerChannelPool) {
            this.targetServiceAccounts = ImmutableList.copyOf(targetServiceAccounts);
            this.lazyHandshakerChannel = new LazyChannel(handshakerChannelPool);
        }

        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator() {
            return new ClientAltsProtocolNegotiator(new ClientTsiHandshakerFactory(this.targetServiceAccounts, this.lazyHandshakerChannel), this.lazyHandshakerChannel);
        }
    }
}

