/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.protobuf.ByteString;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.benchmarks.qps.ServerConfiguration;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.Payload;
import io.grpc.testing.PayloadType;
import io.grpc.testing.SimpleRequest;
import io.grpc.testing.SimpleResponse;
import io.grpc.testing.TestServiceGrpc;
import io.grpc.testing.TestUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public class AsyncServer {
    public static void main(String ... args) throws Exception {
        new AsyncServer().run(args);
    }

    public void run(String[] args) throws Exception {
        ServerConfiguration config;
        ServerConfiguration.Builder configBuilder = ServerConfiguration.newBuilder();
        try {
            config = (ServerConfiguration)configBuilder.build(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            configBuilder.printUsage();
            return;
        }
        final Server server = AsyncServer.newServer(config);
        server.start();
        System.out.println("QPS Server started on " + config.address);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("QPS Server shutting down");
                    server.shutdown();
                    server.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static Server newServer(ServerConfiguration config) throws IOException {
        Class channelType;
        NioEventLoopGroup worker;
        NioEventLoopGroup boss;
        SslContext sslContext = null;
        if (config.tls) {
            System.out.println("Using fake CA for TLS certificate.\nRun the Java client with --tls --testca");
            File cert = TestUtils.loadCert((String)"server1.pem");
            File key = TestUtils.loadCert((String)"server1.key");
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((File)cert, (File)key);
            sslContextBuilder = config.transport == ServerConfiguration.Transport.NETTY_NIO ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.JDK) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.OPENSSL);
            if (config.useDefaultCiphers) {
                sslContextBuilder.ciphers(null);
            }
            sslContext = sslContextBuilder.build();
        }
        switch (config.transport) {
            case NETTY_NIO: {
                boss = new NioEventLoopGroup();
                worker = new NioEventLoopGroup();
                channelType = NioServerSocketChannel.class;
                break;
            }
            case NETTY_EPOLL: {
                Class<?> groupClass;
                try {
                    groupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                    Class<?> channelClass = Class.forName("io.netty.channel.epoll.EpollServerSocketChannel");
                    boss = (EventLoopGroup)groupClass.newInstance();
                    worker = (EventLoopGroup)groupClass.newInstance();
                    channelType = channelClass;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case NETTY_UNIX_DOMAIN_SOCKET: {
                Class<?> groupClass;
                try {
                    groupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                    Class<?> channelClass = Class.forName("io.netty.channel.epoll.EpollServerDomainSocketChannel");
                    boss = (EventLoopGroup)groupClass.newInstance();
                    worker = (EventLoopGroup)groupClass.newInstance();
                    channelType = channelClass;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported transport: " + (Object)((Object)config.transport));
            }
        }
        NettyServerBuilder builder = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)config.address).bossEventLoopGroup((EventLoopGroup)boss).workerEventLoopGroup((EventLoopGroup)worker).channelType(channelType).addService(TestServiceGrpc.bindService(new TestServiceImpl()))).sslContext(sslContext).flowControlWindow(config.flowControlWindow);
        if (config.directExecutor) {
            builder.directExecutor();
        }
        return builder.build();
    }

    public static class TestServiceImpl
    implements TestServiceGrpc.TestService {
        @Override
        public void unaryCall(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            SimpleResponse response = TestServiceImpl.buildSimpleResponse(request);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }

        @Override
        public StreamObserver<SimpleRequest> streamingCall(final StreamObserver<SimpleResponse> responseObserver) {
            return new StreamObserver<SimpleRequest>(){

                public void onNext(SimpleRequest request) {
                    SimpleResponse response = TestServiceImpl.buildSimpleResponse(request);
                    responseObserver.onNext((Object)response);
                }

                public void onError(Throwable t) {
                    System.out.println("Encountered an error in streamingCall");
                    t.printStackTrace();
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }

        private static SimpleResponse buildSimpleResponse(SimpleRequest request) {
            if (request.getResponseSize() > 0) {
                if (!PayloadType.COMPRESSABLE.equals((Object)request.getResponseType())) {
                    throw Status.INTERNAL.augmentDescription("Error creating payload.").asRuntimeException();
                }
                ByteString body = ByteString.copyFrom((byte[])new byte[request.getResponseSize()]);
                PayloadType type = request.getResponseType();
                Payload payload = Payload.newBuilder().setType(type).setBody(body).build();
                return SimpleResponse.newBuilder().setPayload(payload).build();
            }
            return SimpleResponse.getDefaultInstance();
        }
    }
}

