/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.driver;

import com.sun.management.OperatingSystemMXBean;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.benchmarks.ByteBufOutputMarshaller;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.proto.BenchmarkServiceGrpc;
import io.grpc.benchmarks.proto.Control;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.proto.Stats;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.TestUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LoadServer {
    static final MethodDescriptor<ByteBuf, ByteBuf> GENERIC_UNARY_METHOD = MethodDescriptor.create((MethodDescriptor.MethodType)BenchmarkServiceGrpc.METHOD_UNARY_CALL.getType(), (String)BenchmarkServiceGrpc.METHOD_UNARY_CALL.getFullMethodName(), (MethodDescriptor.Marshaller)new ByteBufOutputMarshaller(), (MethodDescriptor.Marshaller)new ByteBufOutputMarshaller());
    static final MethodDescriptor<ByteBuf, ByteBuf> GENERIC_STREAMING_PING_PONG_METHOD = MethodDescriptor.create((MethodDescriptor.MethodType)BenchmarkServiceGrpc.METHOD_STREAMING_CALL.getType(), (String)BenchmarkServiceGrpc.METHOD_STREAMING_CALL.getFullMethodName(), (MethodDescriptor.Marshaller)new ByteBufOutputMarshaller(), (MethodDescriptor.Marshaller)new ByteBufOutputMarshaller());
    private static final Logger LOG = Logger.getLogger(LoadServer.class.getName());
    private final Server server;
    private final BenchmarkServiceImpl benchmarkService;
    private final OperatingSystemMXBean osBean;
    private volatile boolean shutdown;
    private final int port;
    private ByteBuf genericResponse;
    private long lastStatTime;
    private long lastMarkCpuTime;

    LoadServer(Control.ServerConfig config) throws Exception {
        LOG.log(Level.INFO, "Server Config \n" + config.toString());
        this.port = config.getPort() == 0 ? TestUtils.pickUnusedPort() : config.getPort();
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)this.port);
        int asyncThreads = config.getAsyncServerThreads() == 0 ? Runtime.getRuntime().availableProcessors() : config.getAsyncServerThreads();
        switch (config.getServerType()) {
            case ASYNC_SERVER: {
                serverBuilder.executor((Executor)Executors.newFixedThreadPool(asyncThreads, (ThreadFactory)new DefaultThreadFactory("server-worker", true)));
                break;
            }
            case SYNC_SERVER: {
                serverBuilder.directExecutor();
                break;
            }
            case ASYNC_GENERIC_SERVER: {
                serverBuilder.executor((Executor)Executors.newFixedThreadPool(asyncThreads, (ThreadFactory)new DefaultThreadFactory("server-worker", true)));
                PooledByteBufAllocator alloc = PooledByteBufAllocator.DEFAULT;
                this.genericResponse = alloc.buffer(config.getPayloadConfig().getBytebufParams().getRespSize());
                if (this.genericResponse.capacity() <= 0) break;
                this.genericResponse.writerIndex(this.genericResponse.capacity() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (config.hasSecurityParams()) {
            File cert = TestUtils.loadCert((String)"server1.pem");
            File key = TestUtils.loadCert((String)"server1.key");
            serverBuilder.useTransportSecurity(cert, key);
        }
        this.benchmarkService = new BenchmarkServiceImpl();
        if (config.getServerType() == Control.ServerType.ASYNC_GENERIC_SERVER) {
            serverBuilder.addService(ServerServiceDefinition.builder((String)"grpc.testing.BenchmarkService").addMethod(GENERIC_STREAMING_PING_PONG_METHOD, (ServerCallHandler)new GenericServiceCallHandler()).build());
        } else {
            serverBuilder.addService(BenchmarkServiceGrpc.bindService(this.benchmarkService));
        }
        this.server = serverBuilder.build();
        List<OperatingSystemMXBean> beans = ManagementFactory.getPlatformMXBeans(OperatingSystemMXBean.class);
        this.osBean = !beans.isEmpty() ? beans.get(0) : null;
    }

    int getPort() {
        return this.port;
    }

    int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    void start() throws Exception {
        this.server.start();
        this.lastStatTime = System.nanoTime();
        if (this.osBean != null) {
            this.lastMarkCpuTime = this.osBean.getProcessCpuTime();
        }
    }

    Stats.ServerStats getStats() {
        Stats.ServerStats.Builder builder = Stats.ServerStats.newBuilder();
        long now = System.nanoTime();
        double elapsed = ((double)now - (double)this.lastStatTime) / 1.0E9;
        this.lastStatTime = now;
        builder.setTimeElapsed(elapsed);
        if (this.osBean != null) {
            long nowCpu = this.osBean.getProcessCpuTime();
            builder.setTimeUser(((double)nowCpu - (double)this.lastMarkCpuTime) / 1.0E9);
            this.lastMarkCpuTime = nowCpu;
        }
        return builder.build();
    }

    void shutdownNow() {
        this.shutdown = true;
        this.server.shutdownNow();
    }

    private class GenericServiceCallHandler
    implements ServerCallHandler<ByteBuf, ByteBuf> {
        private GenericServiceCallHandler() {
        }

        public ServerCall.Listener<ByteBuf> startCall(MethodDescriptor<ByteBuf, ByteBuf> method, final ServerCall<ByteBuf> call, Metadata headers) {
            call.sendHeaders(new Metadata());
            call.request(1);
            return new ServerCall.Listener<ByteBuf>(){

                public void onMessage(ByteBuf message) {
                    message.release();
                    call.request(1);
                    call.sendMessage((Object)LoadServer.this.genericResponse.slice());
                }

                public void onHalfClose() {
                    call.close(Status.OK, new Metadata());
                }

                public void onCancel() {
                }

                public void onComplete() {
                }
            };
        }
    }

    private class BenchmarkServiceImpl
    implements BenchmarkServiceGrpc.BenchmarkService {
        private BenchmarkServiceImpl() {
        }

        @Override
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            responseObserver.onNext((Object)Utils.makeResponse(request));
            responseObserver.onCompleted();
        }

        @Override
        public StreamObserver<Messages.SimpleRequest> streamingCall(final StreamObserver<Messages.SimpleResponse> responseObserver) {
            return new StreamObserver<Messages.SimpleRequest>(){

                public void onNext(Messages.SimpleRequest value) {
                    if (!LoadServer.this.shutdown) {
                        responseObserver.onNext((Object)Utils.makeResponse(value));
                    } else {
                        responseObserver.onCompleted();
                    }
                }

                public void onError(Throwable t) {
                    responseObserver.onError(t);
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }
    }
}

