/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import io.grpc.ManagedChannel;
import io.grpc.benchmarks.Transport;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.proto.Control;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.qps.AbstractConfigurationBuilder;
import io.grpc.benchmarks.qps.Configuration;
import io.grpc.testing.TestUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClientConfiguration
implements Configuration {
    private static final ClientConfiguration DEFAULT = new ClientConfiguration();
    Transport transport = Transport.NETTY_NIO;
    boolean tls;
    boolean testca;
    String authorityOverride = "foo.test.google.fr";
    boolean useDefaultCiphers;
    boolean directExecutor;
    SocketAddress address;
    int channels = 4;
    int outstandingRpcsPerChannel = 10;
    int serverPayload;
    int clientPayload;
    int flowControlWindow = 0x100000;
    int duration = 60;
    int warmupDuration = 10;
    int targetQps;
    String histogramFile;
    Control.RpcType rpcType = Control.RpcType.UNARY;
    Messages.PayloadType payloadType = Messages.PayloadType.COMPRESSABLE;

    private ClientConfiguration() {
    }

    public ManagedChannel newChannel() throws IOException {
        return Utils.newClientChannel(Transport.NETTY_EPOLL, this.address, this.tls, this.testca, this.authorityOverride, this.useDefaultCiphers, this.flowControlWindow, this.directExecutor);
    }

    public Messages.SimpleRequest newRequest() {
        return Utils.makeRequest(this.payloadType, this.clientPayload, this.serverPayload);
    }

    static Builder newBuilder(ClientParam ... supportedParams) {
        return new Builder(supportedParams);
    }

    static /* synthetic */ ClientConfiguration access$300() {
        return DEFAULT;
    }

    static enum ClientParam implements AbstractConfigurationBuilder.Param
    {
        ADDRESS("STR", "Socket address (host:port) or Unix Domain Socket file name (unix:///path/to/file), depending on the transport selected.", null, true){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.address = Utils.parseSocketAddress(value);
            }
        }
        ,
        CHANNELS("INT", "Number of Channels.", "" + ClientConfiguration.access$300().channels){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.channels = Integer.parseInt(value);
            }
        }
        ,
        OUTSTANDING_RPCS("INT", "Number of outstanding RPCs per Channel.", "" + ClientConfiguration.access$300().outstandingRpcsPerChannel){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.outstandingRpcsPerChannel = Integer.parseInt(value);
            }
        }
        ,
        CLIENT_PAYLOAD("BYTES", "Payload Size of the Request.", "" + ClientConfiguration.access$300().clientPayload){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.clientPayload = Integer.parseInt(value);
            }
        }
        ,
        SERVER_PAYLOAD("BYTES", "Payload Size of the Response.", "" + ClientConfiguration.access$300().serverPayload){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.serverPayload = Integer.parseInt(value);
            }
        }
        ,
        TLS("", "Enable TLS.", "" + ClientConfiguration.access$300().tls){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.tls = Utils.parseBoolean(value);
            }
        }
        ,
        TESTCA("", "Use the provided Test Certificate for TLS.", "" + ClientConfiguration.access$300().testca){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.testca = Utils.parseBoolean(value);
            }
        }
        ,
        USE_DEFAULT_CIPHERS("", "Use the default JDK ciphers for TLS (Used to support Java 7).", "" + ClientConfiguration.access$300().useDefaultCiphers){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.useDefaultCiphers = Utils.parseBoolean(value);
            }
        }
        ,
        TRANSPORT("STR", Transport.getDescriptionString(), ClientConfiguration.access$300().transport.name().toLowerCase()){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.transport = Transport.valueOf(value.toUpperCase());
            }
        }
        ,
        DURATION("SECONDS", "Duration of the benchmark.", "" + ClientConfiguration.access$300().duration){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.duration = Integer.parseInt(value);
            }
        }
        ,
        WARMUP_DURATION("SECONDS", "Warmup Duration of the benchmark.", "" + ClientConfiguration.access$300().warmupDuration){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.warmupDuration = Integer.parseInt(value);
            }
        }
        ,
        DIRECTEXECUTOR("", "Don't use a threadpool for RPC calls, instead execute calls directly in the transport thread.", "" + ClientConfiguration.access$300().directExecutor){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.directExecutor = Utils.parseBoolean(value);
            }
        }
        ,
        SAVE_HISTOGRAM("FILE", "Write the histogram with the latency recordings to file.", null){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.histogramFile = value;
            }
        }
        ,
        STREAMING_RPCS("", "Use Streaming RPCs.", "false"){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.rpcType = Control.RpcType.STREAMING;
            }
        }
        ,
        FLOW_CONTROL_WINDOW("BYTES", "The HTTP/2 flow control window.", "" + ClientConfiguration.access$300().flowControlWindow){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.flowControlWindow = Integer.parseInt(value);
            }
        }
        ,
        TARGET_QPS("INT", "Average number of QPS to shoot for.", "" + ClientConfiguration.access$300().targetQps, true){

            @Override
            protected void setClientValue(ClientConfiguration config, String value) {
                config.targetQps = Integer.parseInt(value);
            }
        };

        private final String type;
        private final String description;
        private final String defaultValue;
        private final boolean required;

        private ClientParam(String type, String description, String defaultValue) {
            this(type, description, defaultValue, false);
        }

        private ClientParam(String type, String description, String defaultValue, boolean required) {
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
            this.required = required;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase();
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public void setValue(Configuration config, String value) {
            this.setClientValue((ClientConfiguration)config, value);
        }

        protected abstract void setClientValue(ClientConfiguration var1, String var2);
    }

    static final class Builder
    extends AbstractConfigurationBuilder<ClientConfiguration> {
        private final Collection<AbstractConfigurationBuilder.Param> supportedParams;

        private Builder(ClientParam ... supportedParams) {
            this.supportedParams = Builder.supportedOptionsSet(supportedParams);
        }

        @Override
        protected ClientConfiguration newConfiguration() {
            return new ClientConfiguration();
        }

        @Override
        protected Collection<AbstractConfigurationBuilder.Param> getParams() {
            return this.supportedParams;
        }

        @Override
        protected ClientConfiguration build0(ClientConfiguration config) {
            if (config.tls) {
                if (!config.transport.tlsSupported) {
                    throw new IllegalArgumentException("Transport " + config.transport.name().toLowerCase() + " does not support TLS.");
                }
                if (config.transport != Transport.OK_HTTP && config.testca && config.address instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)config.address;
                    config.address = TestUtils.testServerAddress((String)address.getHostName(), (int)address.getPort());
                }
            }
            config.transport.validateSocketAddress(config.address);
            return config;
        }

        private static Set<AbstractConfigurationBuilder.Param> supportedOptionsSet(ClientParam ... supportedParams) {
            if (supportedParams.length == 0) {
                supportedParams = ClientParam.values();
            }
            return Collections.unmodifiableSet(new LinkedHashSet<ClientParam>(Arrays.asList(supportedParams)));
        }
    }
}

