/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.driver;

import com.sun.management.OperatingSystemMXBean;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.benchmarks.Transport;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.driver.LoadServer;
import io.grpc.benchmarks.proto.BenchmarkServiceGrpc;
import io.grpc.benchmarks.proto.Control;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.proto.Payloads;
import io.grpc.benchmarks.proto.Stats;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.epoll.Epoll;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.LogarithmicIterator;
import org.HdrHistogram.Recorder;
import org.apache.commons.math3.distribution.ExponentialDistribution;

class LoadClient {
    private static final Logger log = Logger.getLogger(LoadClient.class.getName());
    private ByteBuf genericRequest;
    private final Control.ClientConfig config;
    private final ExponentialDistribution distribution;
    private volatile boolean shutdown;
    private final int threadCount;
    ManagedChannel[] channels;
    BenchmarkServiceGrpc.BenchmarkServiceBlockingStub[] blockingStubs;
    BenchmarkServiceGrpc.BenchmarkServiceStub[] asyncStubs;
    Recorder recorder;
    private ExecutorService fixedThreadPool;
    private Messages.SimpleRequest simpleRequest;
    private final OperatingSystemMXBean osBean;
    private long lastMarkCpuTime;

    LoadClient(Control.ClientConfig config) throws Exception {
        int i;
        log.log(Level.INFO, "Client Config \n" + config.toString());
        this.config = config;
        this.channels = new ManagedChannelImpl[config.getClientChannels()];
        for (i = 0; i < config.getClientChannels(); ++i) {
            this.channels[i] = Utils.newClientChannel(Epoll.isAvailable() ? Transport.NETTY_EPOLL : Transport.NETTY_NIO, Utils.parseSocketAddress(config.getServerTargets(i % config.getServerTargetsCount())), config.hasSecurityParams(), config.hasSecurityParams() && config.getSecurityParams().getUseTestCa(), config.hasSecurityParams() ? config.getSecurityParams().getServerHostOverride() : null, true, 0x100000, false);
        }
        if (config.getClientType() == Control.ClientType.ASYNC_CLIENT) {
            this.asyncStubs = new BenchmarkServiceGrpc.BenchmarkServiceStub[this.channels.length];
            for (i = 0; i < this.channels.length; ++i) {
                this.asyncStubs[i] = BenchmarkServiceGrpc.newStub((Channel)this.channels[i]);
            }
        } else {
            this.blockingStubs = new BenchmarkServiceGrpc.BenchmarkServiceBlockingStub[this.channels.length];
            for (i = 0; i < this.channels.length; ++i) {
                this.blockingStubs[i] = BenchmarkServiceGrpc.newBlockingStub((Channel)this.channels[i]);
            }
        }
        this.threadCount = config.getClientType() == Control.ClientType.SYNC_CLIENT ? config.getOutstandingRpcsPerChannel() * config.getClientChannels() : (config.getAsyncClientThreads() == 0 ? Runtime.getRuntime().availableProcessors() : config.getAsyncClientThreads());
        this.fixedThreadPool = Executors.newFixedThreadPool(this.threadCount, (ThreadFactory)new DefaultThreadFactory("client-worker", true));
        switch (config.getLoadParams().getLoadCase()) {
            case CLOSED_LOOP: {
                this.distribution = null;
                break;
            }
            case LOAD_NOT_SET: {
                this.distribution = null;
                break;
            }
            case POISSON: {
                this.distribution = new ExponentialDistribution((double)this.threadCount / config.getLoadParams().getPoisson().getOfferedLoad());
                break;
            }
            default: {
                throw new IllegalArgumentException("Scenario not implemented");
            }
        }
        switch (config.getPayloadConfig().getPayloadCase()) {
            case SIMPLE_PARAMS: {
                Payloads.SimpleProtoParams simpleParams = config.getPayloadConfig().getSimpleParams();
                this.simpleRequest = Utils.makeRequest(Messages.PayloadType.COMPRESSABLE, simpleParams.getReqSize(), simpleParams.getRespSize());
                break;
            }
            case BYTEBUF_PARAMS: {
                PooledByteBufAllocator alloc = PooledByteBufAllocator.DEFAULT;
                this.genericRequest = alloc.buffer(config.getPayloadConfig().getBytebufParams().getRespSize());
                if (this.genericRequest.capacity() <= 0) break;
                this.genericRequest.writerIndex(this.genericRequest.capacity() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Scenario not implemented");
            }
        }
        List<OperatingSystemMXBean> beans = ManagementFactory.getPlatformMXBeans(OperatingSystemMXBean.class);
        this.osBean = !beans.isEmpty() ? beans.get(0) : null;
        this.recorder = new Recorder((long)config.getHistogramParams().getMaxPossible(), 3);
    }

    void start() {
        for (int i = 0; i < this.threadCount; ++i) {
            Runnable r = null;
            switch (this.config.getPayloadConfig().getPayloadCase()) {
                case SIMPLE_PARAMS: {
                    if (this.config.getClientType() == Control.ClientType.SYNC_CLIENT) {
                        if (this.config.getRpcType() != Control.RpcType.UNARY) break;
                        r = new BlockingUnaryWorker(this.blockingStubs[i % this.blockingStubs.length]);
                        break;
                    }
                    if (this.config.getClientType() != Control.ClientType.ASYNC_CLIENT) break;
                    if (this.config.getRpcType() == Control.RpcType.UNARY) {
                        r = new AsyncUnaryWorker(this.asyncStubs[i % this.asyncStubs.length]);
                        break;
                    }
                    if (this.config.getRpcType() != Control.RpcType.STREAMING) break;
                    r = new AsyncPingPongWorker(this.asyncStubs[i % this.asyncStubs.length]);
                    break;
                }
                case BYTEBUF_PARAMS: {
                    if (this.config.getClientType() == Control.ClientType.SYNC_CLIENT) {
                        if (this.config.getRpcType() != Control.RpcType.UNARY) break;
                        r = new GenericBlockingUnaryWorker((Channel)this.channels[i % this.channels.length]);
                        break;
                    }
                    if (this.config.getClientType() != Control.ClientType.ASYNC_CLIENT) break;
                    if (this.config.getRpcType() == Control.RpcType.UNARY) {
                        r = new GenericAsyncUnaryWorker((Channel)this.channels[i % this.channels.length]);
                        break;
                    }
                    if (this.config.getRpcType() != Control.RpcType.STREAMING) break;
                    r = new GenericAsyncPingPongWorker((Channel)this.channels[i % this.channels.length]);
                    break;
                }
                default: {
                    throw Status.UNIMPLEMENTED.withDescription("Unknown payload case " + this.config.getPayloadConfig().getPayloadCase().name()).asRuntimeException();
                }
            }
            if (r == null) {
                throw new IllegalStateException(this.config.getRpcType().name() + " not supported for client type " + (Object)((Object)this.config.getClientType()));
            }
            this.fixedThreadPool.execute(r);
        }
        if (this.osBean != null) {
            this.lastMarkCpuTime = this.osBean.getProcessCpuTime();
        }
    }

    Stats.ClientStats getStats() {
        Histogram intervalHistogram = this.recorder.getIntervalHistogram();
        Stats.ClientStats.Builder statsBuilder = Stats.ClientStats.newBuilder();
        Stats.HistogramData.Builder latenciesBuilder = statsBuilder.getLatenciesBuilder();
        double resolution = 1.0 + Math.max(this.config.getHistogramParams().getResolution(), 0.01);
        LogarithmicIterator logIterator = new LogarithmicIterator((AbstractHistogram)intervalHistogram, 1L, resolution);
        double base = 1.0;
        while (logIterator.hasNext()) {
            latenciesBuilder.addBucket((int)logIterator.next().getCountAddedInThisIterationStep());
            base *= resolution;
        }
        while (base < this.config.getHistogramParams().getMaxPossible()) {
            latenciesBuilder.addBucket(0);
            base *= resolution;
        }
        latenciesBuilder.setMaxSeen(intervalHistogram.getMaxValue());
        latenciesBuilder.setMinSeen(intervalHistogram.getMinNonZeroValue());
        latenciesBuilder.setCount(intervalHistogram.getTotalCount());
        latenciesBuilder.setSum(intervalHistogram.getMean() * (double)intervalHistogram.getTotalCount());
        statsBuilder.setTimeElapsed((double)(intervalHistogram.getEndTimeStamp() - intervalHistogram.getStartTimeStamp()) / 1000.0);
        if (this.osBean != null) {
            long nowCpu = this.osBean.getProcessCpuTime();
            statsBuilder.setTimeUser(((double)nowCpu - (double)this.lastMarkCpuTime) / 1.0E9);
            this.lastMarkCpuTime = nowCpu;
        }
        return statsBuilder.build();
    }

    void shutdownNow() {
        int i;
        this.shutdown = true;
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].shutdown();
        }
        for (i = 0; i < this.channels.length; ++i) {
            try {
                this.channels[i].awaitTermination(1L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException ie) {
                this.channels[i].shutdownNow();
            }
        }
        this.fixedThreadPool.shutdownNow();
    }

    void delay(long alreadyElapsed) {
        long nextPermitted;
        this.recorder.recordValue(alreadyElapsed);
        if (this.distribution != null && (nextPermitted = Math.round(this.distribution.sample() * 1.0E9)) > alreadyElapsed) {
            LockSupport.parkNanos(nextPermitted - alreadyElapsed);
        }
    }

    private class GenericAsyncPingPongWorker
    implements Runnable {
        final Semaphore maxOutstanding;
        final Channel channel;

        GenericAsyncPingPongWorker(Channel channel) {
            this.maxOutstanding = new Semaphore(LoadClient.this.config.getOutstandingRpcsPerChannel());
            this.channel = channel;
        }

        @Override
        public void run() {
            while (!LoadClient.this.shutdown) {
                this.maxOutstanding.acquireUninterruptibly();
                final ClientCall call = this.channel.newCall(LoadServer.GENERIC_STREAMING_PING_PONG_METHOD, CallOptions.DEFAULT);
                call.start((ClientCall.Listener)new ClientCall.Listener<ByteBuf>(){
                    long now = System.nanoTime();

                    public void onMessage(ByteBuf message) {
                        LoadClient.this.delay(System.nanoTime() - this.now);
                        call.request(1);
                        call.sendMessage((Object)LoadClient.this.genericRequest.slice());
                        this.now = System.nanoTime();
                        if (LoadClient.this.shutdown) {
                            call.cancel("Shutting down", null);
                        }
                    }

                    public void onClose(Status status, Metadata trailers) {
                        GenericAsyncPingPongWorker.this.maxOutstanding.release();
                        if (!status.isOk() && status.getCode() != Status.Code.CANCELLED) {
                            log.log(Level.INFO, "Error in Generic Async Ping-Pong call", status.getCause());
                        }
                    }
                }, new Metadata());
                call.request(1);
                call.sendMessage((Object)LoadClient.this.genericRequest.slice());
            }
        }
    }

    private class GenericAsyncUnaryWorker
    implements Runnable {
        final Channel channel;
        final Semaphore maxOutstanding;

        GenericAsyncUnaryWorker(Channel channel) {
            this.maxOutstanding = new Semaphore(LoadClient.this.config.getOutstandingRpcsPerChannel());
            this.channel = channel;
        }

        @Override
        public void run() {
            while (!LoadClient.this.shutdown) {
                this.maxOutstanding.acquireUninterruptibly();
                ClientCalls.asyncUnaryCall((ClientCall)this.channel.newCall(LoadServer.GENERIC_UNARY_METHOD, CallOptions.DEFAULT), (Object)LoadClient.this.genericRequest.slice(), (StreamObserver)new StreamObserver<ByteBuf>(){
                    long now = System.nanoTime();

                    public void onNext(ByteBuf value) {
                    }

                    public void onError(Throwable t) {
                        GenericAsyncUnaryWorker.this.maxOutstanding.release();
                        log.log(Level.INFO, "Error in Generic Async Unary call", t);
                    }

                    public void onCompleted() {
                        LoadClient.this.delay(System.nanoTime() - this.now);
                        GenericAsyncUnaryWorker.this.maxOutstanding.release();
                    }
                });
            }
        }
    }

    private class GenericBlockingUnaryWorker
    implements Runnable {
        final Channel channel;

        GenericBlockingUnaryWorker(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            while (!LoadClient.this.shutdown) {
                long now = System.nanoTime();
                ClientCalls.blockingUnaryCall((Channel)this.channel, LoadServer.GENERIC_UNARY_METHOD, (CallOptions)CallOptions.DEFAULT, (Object)LoadClient.this.genericRequest.slice());
                LoadClient.this.delay(System.nanoTime() - now);
            }
        }
    }

    private class AsyncPingPongWorker
    implements Runnable {
        final BenchmarkServiceGrpc.BenchmarkServiceStub stub;
        final Semaphore maxOutstanding;

        AsyncPingPongWorker(BenchmarkServiceGrpc.BenchmarkServiceStub stub) {
            this.maxOutstanding = new Semaphore(LoadClient.this.config.getOutstandingRpcsPerChannel());
            this.stub = stub;
        }

        @Override
        public void run() {
            while (!LoadClient.this.shutdown) {
                this.maxOutstanding.acquireUninterruptibly();
                final AtomicReference<StreamObserver<Messages.SimpleRequest>> requestObserver = new AtomicReference<StreamObserver<Messages.SimpleRequest>>();
                requestObserver.set(this.stub.streamingCall(new StreamObserver<Messages.SimpleResponse>(){
                    long now = System.nanoTime();

                    public void onNext(Messages.SimpleResponse value) {
                        LoadClient.this.delay(System.nanoTime() - this.now);
                        ((StreamObserver)requestObserver.get()).onNext((Object)LoadClient.this.simpleRequest);
                        this.now = System.nanoTime();
                        if (LoadClient.this.shutdown) {
                            ((StreamObserver)requestObserver.get()).onCompleted();
                        }
                    }

                    public void onError(Throwable t) {
                        AsyncPingPongWorker.this.maxOutstanding.release();
                        log.log(Level.INFO, "Error in Async Ping-Pong call", t);
                    }

                    public void onCompleted() {
                        AsyncPingPongWorker.this.maxOutstanding.release();
                    }
                }));
                ((StreamObserver)requestObserver.get()).onNext((Object)LoadClient.this.simpleRequest);
            }
        }
    }

    private class AsyncUnaryWorker
    implements Runnable {
        final BenchmarkServiceGrpc.BenchmarkServiceStub stub;
        final Semaphore maxOutstanding;

        AsyncUnaryWorker(BenchmarkServiceGrpc.BenchmarkServiceStub stub) {
            this.maxOutstanding = new Semaphore(LoadClient.this.config.getOutstandingRpcsPerChannel());
            this.stub = stub;
        }

        @Override
        public void run() {
            while (!LoadClient.this.shutdown) {
                this.maxOutstanding.acquireUninterruptibly();
                this.stub.unaryCall(LoadClient.this.simpleRequest, new StreamObserver<Messages.SimpleResponse>(){
                    long now = System.nanoTime();

                    public void onNext(Messages.SimpleResponse value) {
                    }

                    public void onError(Throwable t) {
                        AsyncUnaryWorker.this.maxOutstanding.release();
                        log.log(Level.INFO, "Error in AsyncUnary call", t);
                    }

                    public void onCompleted() {
                        LoadClient.this.delay(System.nanoTime() - this.now);
                        AsyncUnaryWorker.this.maxOutstanding.release();
                    }
                });
            }
        }
    }

    class BlockingUnaryWorker
    implements Runnable {
        final BenchmarkServiceGrpc.BenchmarkServiceBlockingStub stub;

        private BlockingUnaryWorker(BenchmarkServiceGrpc.BenchmarkServiceBlockingStub stub) {
            this.stub = stub;
        }

        @Override
        public void run() {
            while (!LoadClient.this.shutdown) {
                long now = System.nanoTime();
                this.stub.unaryCall(LoadClient.this.simpleRequest);
                LoadClient.this.delay(System.nanoTime() - now);
            }
        }
    }
}

