/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.Marshaller;
import io.grpc.MethodDescriptor;
import io.grpc.MethodType;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractServiceDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.Calls;
import io.grpc.stub.Method;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.SimpleRequest;
import io.grpc.testing.SimpleResponse;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

public class TestServiceGrpc {
    private static final Method<SimpleRequest, SimpleResponse> METHOD_UNARY_CALL = Method.create((MethodType)MethodType.UNARY, (String)"UnaryCall", (Marshaller)ProtoUtils.marshaller(SimpleRequest.PARSER), (Marshaller)ProtoUtils.marshaller(SimpleResponse.PARSER));
    private static final Method<SimpleRequest, SimpleResponse> METHOD_STREAMING_CALL = Method.create((MethodType)MethodType.DUPLEX_STREAMING, (String)"StreamingCall", (Marshaller)ProtoUtils.marshaller(SimpleRequest.PARSER), (Marshaller)ProtoUtils.marshaller(SimpleResponse.PARSER));
    public static final TestServiceServiceDescriptor CONFIG = new TestServiceServiceDescriptor();

    public static TestServiceStub newStub(Channel channel) {
        return new TestServiceStub(channel, CONFIG);
    }

    public static TestServiceBlockingStub newBlockingStub(Channel channel) {
        return new TestServiceBlockingStub(channel, CONFIG);
    }

    public static TestServiceFutureStub newFutureStub(Channel channel) {
        return new TestServiceFutureStub(channel, CONFIG);
    }

    public static ServerServiceDefinition bindService(final TestService serviceImpl) {
        return ServerServiceDefinition.builder((String)"grpc.testing.TestService").addMethod(ServerCalls.createMethodDefinition(METHOD_UNARY_CALL, (ServerCallHandler)ServerCalls.asyncUnaryRequestCall((ServerCalls.UnaryRequestMethod)new ServerCalls.UnaryRequestMethod<SimpleRequest, SimpleResponse>(){

            public void invoke(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
                serviceImpl.unaryCall(request, responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_STREAMING_CALL, (ServerCallHandler)ServerCalls.asyncStreamingRequestCall((ServerCalls.StreamingRequestMethod)new ServerCalls.StreamingRequestMethod<SimpleRequest, SimpleResponse>(){

            public StreamObserver<SimpleRequest> invoke(StreamObserver<SimpleResponse> responseObserver) {
                return serviceImpl.streamingCall(responseObserver);
            }
        }))).build();
    }

    public static class TestServiceFutureStub
    extends AbstractStub<TestServiceFutureStub, TestServiceServiceDescriptor>
    implements TestServiceFutureClient {
        private TestServiceFutureStub(Channel channel, TestServiceServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected TestServiceFutureStub build(Channel channel, TestServiceServiceDescriptor config) {
            return new TestServiceFutureStub(channel, config);
        }

        @Override
        public ListenableFuture<SimpleResponse> unaryCall(SimpleRequest request) {
            return Calls.unaryFutureCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).unaryCall), (Object)request);
        }
    }

    public static class TestServiceBlockingStub
    extends AbstractStub<TestServiceBlockingStub, TestServiceServiceDescriptor>
    implements TestServiceBlockingClient {
        private TestServiceBlockingStub(Channel channel, TestServiceServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected TestServiceBlockingStub build(Channel channel, TestServiceServiceDescriptor config) {
            return new TestServiceBlockingStub(channel, config);
        }

        @Override
        public SimpleResponse unaryCall(SimpleRequest request) {
            return (SimpleResponse)Calls.blockingUnaryCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).unaryCall), (Object)request);
        }
    }

    public static class TestServiceStub
    extends AbstractStub<TestServiceStub, TestServiceServiceDescriptor>
    implements TestService {
        private TestServiceStub(Channel channel, TestServiceServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected TestServiceStub build(Channel channel, TestServiceServiceDescriptor config) {
            return new TestServiceStub(channel, config);
        }

        @Override
        public void unaryCall(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            Calls.asyncUnaryCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).unaryCall), (Object)request, responseObserver);
        }

        @Override
        public StreamObserver<SimpleRequest> streamingCall(StreamObserver<SimpleResponse> responseObserver) {
            return Calls.duplexStreamingCall((Call)this.channel.newCall(((TestServiceServiceDescriptor)this.config).streamingCall), responseObserver);
        }
    }

    public static interface TestServiceFutureClient {
        public ListenableFuture<SimpleResponse> unaryCall(SimpleRequest var1);
    }

    public static interface TestServiceBlockingClient {
        public SimpleResponse unaryCall(SimpleRequest var1);
    }

    public static interface TestService {
        public void unaryCall(SimpleRequest var1, StreamObserver<SimpleResponse> var2);

        public StreamObserver<SimpleRequest> streamingCall(StreamObserver<SimpleResponse> var1);
    }

    @Immutable
    public static class TestServiceServiceDescriptor
    extends AbstractServiceDescriptor<TestServiceServiceDescriptor> {
        public final MethodDescriptor<SimpleRequest, SimpleResponse> unaryCall;
        public final MethodDescriptor<SimpleRequest, SimpleResponse> streamingCall;

        private TestServiceServiceDescriptor() {
            this.unaryCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_UNARY_CALL);
            this.streamingCall = Calls.createMethodDescriptor((String)"grpc.testing.TestService", (Method)METHOD_STREAMING_CALL);
        }

        private TestServiceServiceDescriptor(Map<String, MethodDescriptor<?, ?>> methodMap) {
            this.unaryCall = methodMap.get(TestServiceGrpc.CONFIG.unaryCall.getName());
            this.streamingCall = methodMap.get(TestServiceGrpc.CONFIG.streamingCall.getName());
        }

        protected TestServiceServiceDescriptor build(Map<String, MethodDescriptor<?, ?>> methodMap) {
            return new TestServiceServiceDescriptor(methodMap);
        }

        public ImmutableList<MethodDescriptor<?, ?>> methods() {
            return ImmutableList.of(this.unaryCall, this.streamingCall);
        }
    }
}

