/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.benchmarks.qps.ClientConfiguration;
import io.grpc.testing.Payload;
import io.grpc.testing.SimpleRequest;
import io.grpc.testing.TestUtils;
import io.grpc.transport.netty.GrpcSslContexts;
import io.grpc.transport.netty.NegotiationType;
import io.grpc.transport.netty.NettyChannelBuilder;
import io.grpc.transport.okhttp.OkHttpChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import org.HdrHistogram.Histogram;

final class Utils {
    private static final String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";
    static final long HISTOGRAM_MAX_VALUE = 60000000L;
    static final int HISTOGRAM_PRECISION = 3;

    private Utils() {
    }

    static boolean parseBoolean(String value) {
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    static SocketAddress parseSocketAddress(String value) {
        if (value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            String filePath = value.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
            File file = new File(filePath);
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("File path must be absolute: " + filePath);
            }
            try {
                if (file.createNewFile()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new DomainSocketAddress(file);
        }
        String[] parts = value.split(":", 2);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Address must be a unix:// path or be in the form host:port. Got: " + value);
        }
        String host = parts[0];
        int port = Integer.parseInt(parts[1]);
        return new InetSocketAddress(host, port);
    }

    static SimpleRequest newRequest(ClientConfiguration config) {
        ByteString body = ByteString.copyFrom((byte[])new byte[config.clientPayload]);
        Payload payload = Payload.newBuilder().setType(config.payloadType).setBody(body).build();
        return SimpleRequest.newBuilder().setResponseType(config.payloadType).setResponseSize(config.serverPayload).setPayload(payload).build();
    }

    static Channel newClientChannel(ClientConfiguration config) throws IOException {
        Class<NioSocketChannel> channelType;
        NioEventLoopGroup group;
        NegotiationType negotiationType;
        if (config.transport == ClientConfiguration.Transport.OK_HTTP) {
            InetSocketAddress addr = (InetSocketAddress)config.address;
            return ((OkHttpChannelBuilder)OkHttpChannelBuilder.forAddress((String)addr.getHostName(), (int)addr.getPort()).executor((ExecutorService)(config.directExecutor ? MoreExecutors.newDirectExecutorService() : null))).build();
        }
        SslContext context = null;
        NegotiationType negotiationType2 = negotiationType = config.tls ? NegotiationType.TLS : NegotiationType.PLAINTEXT;
        if (config.tls && config.testca) {
            File cert = TestUtils.loadCert((String)"ca.pem");
            boolean useJdkSsl = config.transport == ClientConfiguration.Transport.NETTY_NIO;
            context = GrpcSslContexts.forClient().trustManager(cert).sslProvider(useJdkSsl ? SslProvider.JDK : SslProvider.OPENSSL).build();
        }
        switch (config.transport) {
            case NETTY_NIO: {
                group = new NioEventLoopGroup();
                channelType = NioSocketChannel.class;
                break;
            }
            case NETTY_EPOLL: {
                group = new EpollEventLoopGroup();
                channelType = EpollSocketChannel.class;
                break;
            }
            case NETTY_UNIX_DOMAIN_SOCKET: {
                group = new EpollEventLoopGroup();
                channelType = EpollDomainSocketChannel.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported transport: " + (Object)((Object)config.transport));
            }
        }
        return ((NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)config.address).eventLoopGroup((EventLoopGroup)group).channelType(channelType).negotiationType(negotiationType).executor((ExecutorService)(config.directExecutor ? MoreExecutors.newDirectExecutorService() : null))).sslContext(context).connectionWindowSize(config.connectionWindow).streamWindowSize(config.streamWindow).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveHistogram(Histogram histogram, String filename) throws IOException {
        PrintStream log = null;
        try {
            File file = new File(filename);
            if (file.exists() && !file.delete()) {
                System.err.println("Failed deleting previous histogram file: " + file.getAbsolutePath());
            }
            log = new PrintStream(new FileOutputStream(file), false);
            histogram.outputPercentileDistribution(log, Double.valueOf(1.0));
        }
        finally {
            if (log != null) {
                log.close();
            }
        }
    }
}

