/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import com.google.common.collect.ImmutableList;
import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.Marshaller;
import io.grpc.MethodDescriptor;
import io.grpc.MethodType;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractServiceDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.Calls;
import io.grpc.stub.Method;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.ClientArgs;
import io.grpc.testing.ClientStatus;
import io.grpc.testing.ServerArgs;
import io.grpc.testing.ServerStatus;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

public class WorkerGrpc {
    private static final Method<ClientArgs, ClientStatus> METHOD_RUN_TEST = Method.create((MethodType)MethodType.DUPLEX_STREAMING, (String)"RunTest", (Marshaller)ProtoUtils.marshaller(ClientArgs.PARSER), (Marshaller)ProtoUtils.marshaller(ClientStatus.PARSER));
    private static final Method<ServerArgs, ServerStatus> METHOD_RUN_SERVER = Method.create((MethodType)MethodType.DUPLEX_STREAMING, (String)"RunServer", (Marshaller)ProtoUtils.marshaller(ServerArgs.PARSER), (Marshaller)ProtoUtils.marshaller(ServerStatus.PARSER));
    public static final WorkerServiceDescriptor CONFIG = new WorkerServiceDescriptor();

    public static WorkerStub newStub(Channel channel) {
        return new WorkerStub(channel, CONFIG);
    }

    public static WorkerBlockingStub newBlockingStub(Channel channel) {
        return new WorkerBlockingStub(channel, CONFIG);
    }

    public static WorkerFutureStub newFutureStub(Channel channel) {
        return new WorkerFutureStub(channel, CONFIG);
    }

    public static ServerServiceDefinition bindService(final Worker serviceImpl) {
        return ServerServiceDefinition.builder((String)"grpc.testing.Worker").addMethod(ServerCalls.createMethodDefinition(METHOD_RUN_TEST, (ServerCallHandler)ServerCalls.asyncStreamingRequestCall((ServerCalls.StreamingRequestMethod)new ServerCalls.StreamingRequestMethod<ClientArgs, ClientStatus>(){

            public StreamObserver<ClientArgs> invoke(StreamObserver<ClientStatus> responseObserver) {
                return serviceImpl.runTest(responseObserver);
            }
        }))).addMethod(ServerCalls.createMethodDefinition(METHOD_RUN_SERVER, (ServerCallHandler)ServerCalls.asyncStreamingRequestCall((ServerCalls.StreamingRequestMethod)new ServerCalls.StreamingRequestMethod<ServerArgs, ServerStatus>(){

            public StreamObserver<ServerArgs> invoke(StreamObserver<ServerStatus> responseObserver) {
                return serviceImpl.runServer(responseObserver);
            }
        }))).build();
    }

    public static class WorkerFutureStub
    extends AbstractStub<WorkerFutureStub, WorkerServiceDescriptor>
    implements WorkerFutureClient {
        private WorkerFutureStub(Channel channel, WorkerServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected WorkerFutureStub build(Channel channel, WorkerServiceDescriptor config) {
            return new WorkerFutureStub(channel, config);
        }
    }

    public static class WorkerBlockingStub
    extends AbstractStub<WorkerBlockingStub, WorkerServiceDescriptor>
    implements WorkerBlockingClient {
        private WorkerBlockingStub(Channel channel, WorkerServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected WorkerBlockingStub build(Channel channel, WorkerServiceDescriptor config) {
            return new WorkerBlockingStub(channel, config);
        }
    }

    public static class WorkerStub
    extends AbstractStub<WorkerStub, WorkerServiceDescriptor>
    implements Worker {
        private WorkerStub(Channel channel, WorkerServiceDescriptor config) {
            super(channel, (AbstractServiceDescriptor)config);
        }

        protected WorkerStub build(Channel channel, WorkerServiceDescriptor config) {
            return new WorkerStub(channel, config);
        }

        @Override
        public StreamObserver<ClientArgs> runTest(StreamObserver<ClientStatus> responseObserver) {
            return Calls.duplexStreamingCall((Call)this.channel.newCall(((WorkerServiceDescriptor)this.config).runTest), responseObserver);
        }

        @Override
        public StreamObserver<ServerArgs> runServer(StreamObserver<ServerStatus> responseObserver) {
            return Calls.duplexStreamingCall((Call)this.channel.newCall(((WorkerServiceDescriptor)this.config).runServer), responseObserver);
        }
    }

    public static interface WorkerFutureClient {
    }

    public static interface WorkerBlockingClient {
    }

    public static interface Worker {
        public StreamObserver<ClientArgs> runTest(StreamObserver<ClientStatus> var1);

        public StreamObserver<ServerArgs> runServer(StreamObserver<ServerStatus> var1);
    }

    @Immutable
    public static class WorkerServiceDescriptor
    extends AbstractServiceDescriptor<WorkerServiceDescriptor> {
        public final MethodDescriptor<ClientArgs, ClientStatus> runTest;
        public final MethodDescriptor<ServerArgs, ServerStatus> runServer;

        private WorkerServiceDescriptor() {
            this.runTest = Calls.createMethodDescriptor((String)"grpc.testing.Worker", (Method)METHOD_RUN_TEST);
            this.runServer = Calls.createMethodDescriptor((String)"grpc.testing.Worker", (Method)METHOD_RUN_SERVER);
        }

        private WorkerServiceDescriptor(Map<String, MethodDescriptor<?, ?>> methodMap) {
            this.runTest = methodMap.get(WorkerGrpc.CONFIG.runTest.getName());
            this.runServer = methodMap.get(WorkerGrpc.CONFIG.runServer.getName());
        }

        protected WorkerServiceDescriptor build(Map<String, MethodDescriptor<?, ?>> methodMap) {
            return new WorkerServiceDescriptor(methodMap);
        }

        public ImmutableList<MethodDescriptor<?, ?>> methods() {
            return ImmutableList.of(this.runTest, this.runServer);
        }
    }
}

