/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.common.base.Preconditions;
import io.grpc.Channel;
import io.grpc.ChannelImpl;
import io.grpc.Status;
import io.grpc.benchmarks.qps.ClientConfiguration;
import io.grpc.benchmarks.qps.Utils;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.SimpleRequest;
import io.grpc.testing.SimpleResponse;
import io.grpc.testing.TestServiceGrpc;
import java.util.Random;
import java.util.concurrent.Callable;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.Histogram;

public class OpenLoopClient {
    private final ClientConfiguration config;

    public OpenLoopClient(ClientConfiguration config) {
        this.config = config;
    }

    public static void main(String ... args) throws Exception {
        ClientConfiguration config;
        ClientConfiguration.Builder configBuilder = ClientConfiguration.newBuilder(ClientConfiguration.ClientParam.ADDRESS, ClientConfiguration.ClientParam.TARGET_QPS, ClientConfiguration.ClientParam.CLIENT_PAYLOAD, ClientConfiguration.ClientParam.SERVER_PAYLOAD, ClientConfiguration.ClientParam.TLS, ClientConfiguration.ClientParam.TESTCA, ClientConfiguration.ClientParam.TRANSPORT, ClientConfiguration.ClientParam.DURATION, ClientConfiguration.ClientParam.SAVE_HISTOGRAM, ClientConfiguration.ClientParam.CONNECTION_WINDOW, ClientConfiguration.ClientParam.STREAM_WINDOW);
        try {
            config = (ClientConfiguration)configBuilder.build(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            configBuilder.printUsage();
            return;
        }
        OpenLoopClient client = new OpenLoopClient(config);
        client.run();
    }

    public void run() throws Exception {
        if (this.config == null) {
            return;
        }
        this.config.channels = 1;
        this.config.directExecutor = true;
        Channel ch = Utils.newClientChannel(this.config);
        SimpleRequest req = Utils.newRequest(this.config);
        LoadGenerationWorker worker = new LoadGenerationWorker(ch, req, this.config.targetQps, this.config.duration);
        long start = System.nanoTime();
        Histogram histogram = worker.call();
        long end = System.nanoTime();
        this.printStats(histogram, end - start);
        if (this.config.histogramFile != null) {
            Utils.saveHistogram(histogram, this.config.histogramFile);
        }
        ((ChannelImpl)ch).shutdown();
    }

    private void printStats(Histogram histogram, long elapsedTime) {
        long latency50 = histogram.getValueAtPercentile(50.0);
        long latency90 = histogram.getValueAtPercentile(90.0);
        long latency95 = histogram.getValueAtPercentile(95.0);
        long latency99 = histogram.getValueAtPercentile(99.0);
        long latency999 = histogram.getValueAtPercentile(99.9);
        long latencyMax = histogram.getValueAtPercentile(100.0);
        long queriesPerSecond = histogram.getTotalCount() * 1000000000L / elapsedTime;
        StringBuilder values = new StringBuilder();
        values.append("Server Payload Size:            ").append(this.config.serverPayload).append('\n').append("Client Payload Size:            ").append(this.config.clientPayload).append('\n').append("50%ile Latency (in micros):     ").append(latency50).append('\n').append("90%ile Latency (in micros):     ").append(latency90).append('\n').append("95%ile Latency (in micros):     ").append(latency95).append('\n').append("99%ile Latency (in micros):     ").append(latency99).append('\n').append("99.9%ile Latency (in micros):   ").append(latency999).append('\n').append("Maximum Latency (in micros):    ").append(latencyMax).append('\n').append("Actual QPS:                     ").append(queriesPerSecond).append('\n').append("Target QPS:                     ").append(this.config.targetQps).append('\n');
        System.out.println(values);
    }

    static class LoadGenerationWorker
    implements Callable<Histogram> {
        final Histogram histogram = new AtomicHistogram(60000000L, 3);
        final TestServiceGrpc.TestServiceStub stub;
        final SimpleRequest request;
        final Random rnd;
        final int targetQps;
        final long numRpcs;

        LoadGenerationWorker(Channel channel, SimpleRequest request, int targetQps, int duration) {
            this.stub = TestServiceGrpc.newStub((Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel"));
            this.request = (SimpleRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
            this.targetQps = targetQps;
            this.numRpcs = targetQps * duration;
            this.rnd = new Random();
        }

        @Override
        public Histogram call() throws Exception {
            long now;
            long nextRpc = now = System.nanoTime();
            long i = 0L;
            while (i < this.numRpcs) {
                now = System.nanoTime();
                if (nextRpc - now > 0L) continue;
                nextRpc += this.nextDelay(this.targetQps);
                this.newRpc(this.stub);
                ++i;
            }
            this.waitForRpcsToComplete(1);
            return this.histogram;
        }

        private void newRpc(TestServiceGrpc.TestServiceStub stub) {
            stub.unaryCall(this.request, new StreamObserver<SimpleResponse>(){
                private final long start = System.nanoTime();

                public void onValue(SimpleResponse value) {
                }

                public void onError(Throwable t) {
                    Status status = Status.fromThrowable((Throwable)t);
                    System.err.println("Encountered an error in unaryCall. Status is " + status);
                    t.printStackTrace();
                }

                public void onCompleted() {
                    long end = System.nanoTime();
                    LoadGenerationWorker.this.histogram.recordValue((end - this.start) / 1000L);
                }
            });
        }

        private void waitForRpcsToComplete(int duration) throws InterruptedException {
            long now = System.nanoTime();
            long end = now + (long)(duration * 1000 * 1000 * 1000);
            while (this.histogram.getTotalCount() < this.numRpcs && now < end) {
                now = System.nanoTime();
            }
        }

        private long nextDelay(int targetQps) {
            double epsilon = 1.11E-16;
            double seconds = -Math.log(Math.max(this.rnd.nextDouble(), 1.11E-16)) / (double)targetQps;
            double nanos = seconds * 1000.0 * 1000.0 * 1000.0;
            return Math.round(nanos);
        }
    }
}

