/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.SimpleRequest;
import io.grpc.testing.SimpleResponse;

public class TestServiceGrpc {
    public static final MethodDescriptor<SimpleRequest, SimpleResponse> METHOD_UNARY_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"grpc.testing.TestService", (String)"UnaryCall", (MethodDescriptor.Marshaller)ProtoUtils.marshaller(SimpleRequest.parser()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller(SimpleResponse.parser()));
    public static final MethodDescriptor<SimpleRequest, SimpleResponse> METHOD_STREAMING_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"grpc.testing.TestService", (String)"StreamingCall", (MethodDescriptor.Marshaller)ProtoUtils.marshaller(SimpleRequest.parser()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller(SimpleResponse.parser()));

    public static TestServiceStub newStub(Channel channel) {
        return new TestServiceStub(channel);
    }

    public static TestServiceBlockingStub newBlockingStub(Channel channel) {
        return new TestServiceBlockingStub(channel);
    }

    public static TestServiceFutureStub newFutureStub(Channel channel) {
        return new TestServiceFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(final TestService serviceImpl) {
        return ServerServiceDefinition.builder((String)"grpc.testing.TestService").addMethod(ServerMethodDefinition.create(METHOD_UNARY_CALL, (ServerCallHandler)ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<SimpleRequest, SimpleResponse>(){

            public void invoke(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
                serviceImpl.unaryCall(request, responseObserver);
            }
        }))).addMethod(ServerMethodDefinition.create(METHOD_STREAMING_CALL, (ServerCallHandler)ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new ServerCalls.BidiStreamingMethod<SimpleRequest, SimpleResponse>(){

            public StreamObserver<SimpleRequest> invoke(StreamObserver<SimpleResponse> responseObserver) {
                return serviceImpl.streamingCall(responseObserver);
            }
        }))).build();
    }

    public static class TestServiceFutureStub
    extends AbstractStub<TestServiceFutureStub>
    implements TestServiceFutureClient {
        private TestServiceFutureStub(Channel channel) {
            super(channel);
        }

        private TestServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<SimpleResponse> unaryCall(SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.channel.newCall(METHOD_UNARY_CALL, this.callOptions), (Object)request);
        }
    }

    public static class TestServiceBlockingStub
    extends AbstractStub<TestServiceBlockingStub>
    implements TestServiceBlockingClient {
        private TestServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private TestServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceBlockingStub(channel, callOptions);
        }

        @Override
        public SimpleResponse unaryCall(SimpleRequest request) {
            return (SimpleResponse)ClientCalls.blockingUnaryCall((ClientCall)this.channel.newCall(METHOD_UNARY_CALL, this.callOptions), (Object)request);
        }
    }

    public static class TestServiceStub
    extends AbstractStub<TestServiceStub>
    implements TestService {
        private TestServiceStub(Channel channel) {
            super(channel);
        }

        private TestServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected TestServiceStub build(Channel channel, CallOptions callOptions) {
            return new TestServiceStub(channel, callOptions);
        }

        @Override
        public void unaryCall(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.channel.newCall(METHOD_UNARY_CALL, this.callOptions), (Object)request, responseObserver);
        }

        @Override
        public StreamObserver<SimpleRequest> streamingCall(StreamObserver<SimpleResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.channel.newCall(METHOD_STREAMING_CALL, this.callOptions), responseObserver);
        }
    }

    public static interface TestServiceFutureClient {
        public ListenableFuture<SimpleResponse> unaryCall(SimpleRequest var1);
    }

    public static interface TestServiceBlockingClient {
        public SimpleResponse unaryCall(SimpleRequest var1);
    }

    public static interface TestService {
        public void unaryCall(SimpleRequest var1, StreamObserver<SimpleResponse> var2);

        public StreamObserver<SimpleRequest> streamingCall(StreamObserver<SimpleResponse> var1);
    }
}

