/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.ClientArgs;
import io.grpc.testing.ClientStatus;
import io.grpc.testing.ServerArgs;
import io.grpc.testing.ServerStatus;

public class WorkerGrpc {
    public static final MethodDescriptor<ClientArgs, ClientStatus> METHOD_RUN_TEST = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"grpc.testing.Worker", (String)"RunTest", (MethodDescriptor.Marshaller)ProtoUtils.marshaller(ClientArgs.parser()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller(ClientStatus.parser()));
    public static final MethodDescriptor<ServerArgs, ServerStatus> METHOD_RUN_SERVER = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"grpc.testing.Worker", (String)"RunServer", (MethodDescriptor.Marshaller)ProtoUtils.marshaller(ServerArgs.parser()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller(ServerStatus.parser()));

    public static WorkerStub newStub(Channel channel) {
        return new WorkerStub(channel);
    }

    public static WorkerBlockingStub newBlockingStub(Channel channel) {
        return new WorkerBlockingStub(channel);
    }

    public static WorkerFutureStub newFutureStub(Channel channel) {
        return new WorkerFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(final Worker serviceImpl) {
        return ServerServiceDefinition.builder((String)"grpc.testing.Worker").addMethod(ServerMethodDefinition.create(METHOD_RUN_TEST, (ServerCallHandler)ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new ServerCalls.BidiStreamingMethod<ClientArgs, ClientStatus>(){

            public StreamObserver<ClientArgs> invoke(StreamObserver<ClientStatus> responseObserver) {
                return serviceImpl.runTest(responseObserver);
            }
        }))).addMethod(ServerMethodDefinition.create(METHOD_RUN_SERVER, (ServerCallHandler)ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new ServerCalls.BidiStreamingMethod<ServerArgs, ServerStatus>(){

            public StreamObserver<ServerArgs> invoke(StreamObserver<ServerStatus> responseObserver) {
                return serviceImpl.runServer(responseObserver);
            }
        }))).build();
    }

    public static class WorkerFutureStub
    extends AbstractStub<WorkerFutureStub>
    implements WorkerFutureClient {
        private WorkerFutureStub(Channel channel) {
            super(channel);
        }

        private WorkerFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected WorkerFutureStub build(Channel channel, CallOptions callOptions) {
            return new WorkerFutureStub(channel, callOptions);
        }
    }

    public static class WorkerBlockingStub
    extends AbstractStub<WorkerBlockingStub>
    implements WorkerBlockingClient {
        private WorkerBlockingStub(Channel channel) {
            super(channel);
        }

        private WorkerBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected WorkerBlockingStub build(Channel channel, CallOptions callOptions) {
            return new WorkerBlockingStub(channel, callOptions);
        }
    }

    public static class WorkerStub
    extends AbstractStub<WorkerStub>
    implements Worker {
        private WorkerStub(Channel channel) {
            super(channel);
        }

        private WorkerStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected WorkerStub build(Channel channel, CallOptions callOptions) {
            return new WorkerStub(channel, callOptions);
        }

        @Override
        public StreamObserver<ClientArgs> runTest(StreamObserver<ClientStatus> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.channel.newCall(METHOD_RUN_TEST, this.callOptions), responseObserver);
        }

        @Override
        public StreamObserver<ServerArgs> runServer(StreamObserver<ServerStatus> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.channel.newCall(METHOD_RUN_SERVER, this.callOptions), responseObserver);
        }
    }

    public static interface WorkerFutureClient {
    }

    public static interface WorkerBlockingClient {
    }

    public static interface Worker {
        public StreamObserver<ClientArgs> runTest(StreamObserver<ClientStatus> var1);

        public StreamObserver<ServerArgs> runServer(StreamObserver<ServerStatus> var1);
    }
}

