/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks;

import io.grpc.benchmarks.SocketAddressValidator;
import java.net.SocketAddress;

public enum Transport {
    NETTY_NIO(true, "The Netty Java NIO transport. Using this with TLS requires that the Java bootclasspath be configured with Jetty ALPN boot.", SocketAddressValidator.INET),
    NETTY_EPOLL(true, "The Netty native EPOLL transport. Using this with TLS requires that OpenSSL be installed and configured as described in http://netty.io/wiki/forked-tomcat-native.html. Only supported on Linux.", SocketAddressValidator.INET),
    NETTY_UNIX_DOMAIN_SOCKET(false, "The Netty Unix Domain Socket transport. This currently does not support TLS.", SocketAddressValidator.UDS),
    OK_HTTP(true, "The OkHttp transport.", SocketAddressValidator.INET);

    public final boolean tlsSupported;
    final String description;
    final SocketAddressValidator socketAddressValidator;

    private Transport(boolean tlsSupported, String description, SocketAddressValidator socketAddressValidator) {
        this.tlsSupported = tlsSupported;
        this.description = description;
        this.socketAddressValidator = socketAddressValidator;
    }

    public void validateSocketAddress(SocketAddress address) {
        if (!this.socketAddressValidator.isValidSocketAddress(address)) {
            throw new IllegalArgumentException("Invalid address " + address + " for transport " + (Object)((Object)this));
        }
    }

    public static String getDescriptionString() {
        StringBuilder builder = new StringBuilder("Select the transport to use. Options:\n");
        boolean first = true;
        for (Transport transport : Transport.values()) {
            if (!first) {
                builder.append("\n");
            }
            builder.append(transport.name().toLowerCase());
            builder.append(": ");
            builder.append(transport.description);
            first = false;
        }
        return builder.toString();
    }
}

