/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.proto.BenchmarkServiceGrpc;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.qps.ServerConfiguration;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.TestUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncServer {
    public static void main(String ... args) throws Exception {
        new AsyncServer().run(args);
    }

    public void run(String[] args) throws Exception {
        ServerConfiguration config;
        ServerConfiguration.Builder configBuilder = ServerConfiguration.newBuilder();
        try {
            config = (ServerConfiguration)configBuilder.build(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            configBuilder.printUsage();
            return;
        }
        final Server server = AsyncServer.newServer(config);
        server.start();
        System.out.println("QPS Server started on " + config.address);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("QPS Server shutting down");
                    server.shutdown();
                    server.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static Server newServer(ServerConfiguration config) throws IOException {
        Class channelType;
        NioEventLoopGroup worker;
        NioEventLoopGroup boss;
        SslContext sslContext = null;
        if (config.tls) {
            System.out.println("Using fake CA for TLS certificate.\nRun the Java client with --tls --testca");
            File cert = TestUtils.loadCert((String)"server1.pem");
            File key = TestUtils.loadCert((String)"server1.key");
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((File)cert, (File)key);
            sslContextBuilder = config.transport == ServerConfiguration.Transport.NETTY_NIO ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.JDK) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.OPENSSL);
            if (config.useDefaultCiphers) {
                sslContextBuilder.ciphers(null);
            }
            sslContext = sslContextBuilder.build();
        }
        switch (config.transport) {
            case NETTY_NIO: {
                boss = new NioEventLoopGroup();
                worker = new NioEventLoopGroup();
                channelType = NioServerSocketChannel.class;
                break;
            }
            case NETTY_EPOLL: {
                Class<?> groupClass;
                try {
                    groupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                    Class<?> channelClass = Class.forName("io.netty.channel.epoll.EpollServerSocketChannel");
                    boss = (EventLoopGroup)groupClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    worker = (EventLoopGroup)groupClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    channelType = channelClass;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case NETTY_UNIX_DOMAIN_SOCKET: {
                Class<?> groupClass;
                try {
                    groupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                    Class<?> channelClass = Class.forName("io.netty.channel.epoll.EpollServerDomainSocketChannel");
                    boss = (EventLoopGroup)groupClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    worker = (EventLoopGroup)groupClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    channelType = channelClass;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported transport: " + (Object)((Object)config.transport));
            }
        }
        NettyServerBuilder builder = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)config.address).bossEventLoopGroup((EventLoopGroup)boss).workerEventLoopGroup((EventLoopGroup)worker).channelType(channelType).addService((BindableService)new BenchmarkServiceImpl())).sslContext(sslContext).flowControlWindow(config.flowControlWindow);
        if (config.directExecutor) {
            builder.directExecutor();
        } else {
            builder.executor((Executor)new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
                final AtomicInteger num = new AtomicInteger();

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    thread.setDaemon(true);
                    thread.setName("grpc-server-app--" + this.num.getAndIncrement());
                    return thread;
                }
            }, UncaughtExceptionHandlers.systemExit(), true));
        }
        return builder.build();
    }

    public static class BenchmarkServiceImpl
    extends BenchmarkServiceGrpc.BenchmarkServiceImplBase {
        @Override
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            Messages.SimpleResponse response = Utils.makeResponse(request);
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }

        @Override
        public StreamObserver<Messages.SimpleRequest> streamingCall(final StreamObserver<Messages.SimpleResponse> responseObserver) {
            return new StreamObserver<Messages.SimpleRequest>(){

                public void onNext(Messages.SimpleRequest request) {
                    Messages.SimpleResponse response = Utils.makeResponse(request);
                    responseObserver.onNext((Object)response);
                }

                public void onError(Throwable t) {
                    System.out.println("Encountered an error in streamingCall");
                    t.printStackTrace();
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }
    }
}

