/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.proto;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.proto.Services;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class BenchmarkServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.BenchmarkService";
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_UNARY_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"UnaryCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance()));
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_STREAMING_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"StreamingCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance()));
    private static final int METHODID_UNARY_CALL = 0;
    private static final int METHODID_STREAMING_CALL = 1;
    private static volatile ServiceDescriptor serviceDescriptor;

    private BenchmarkServiceGrpc() {
    }

    public static BenchmarkServiceStub newStub(Channel channel) {
        return new BenchmarkServiceStub(channel);
    }

    public static BenchmarkServiceBlockingStub newBlockingStub(Channel channel) {
        return new BenchmarkServiceBlockingStub(channel);
    }

    public static BenchmarkServiceFutureStub newFutureStub(Channel channel) {
        return new BenchmarkServiceFutureStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<BenchmarkServiceGrpc> clazz = BenchmarkServiceGrpc.class;
        synchronized (BenchmarkServiceGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new BenchmarkServiceDescriptorSupplier()).addMethod(METHOD_UNARY_CALL).addMethod(METHOD_STREAMING_CALL).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class BenchmarkServiceDescriptorSupplier
    implements ProtoFileDescriptorSupplier {
        private BenchmarkServiceDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return Services.getDescriptor();
        }
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final BenchmarkServiceImplBase serviceImpl;
        private final int methodId;

        public MethodHandlers(BenchmarkServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.unaryCall((Messages.SimpleRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return this.serviceImpl.streamingCall(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class BenchmarkServiceFutureStub
    extends AbstractStub<BenchmarkServiceFutureStub> {
        private BenchmarkServiceFutureStub(Channel channel) {
            super(channel);
        }

        private BenchmarkServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected BenchmarkServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new BenchmarkServiceFutureStub(channel, callOptions);
        }

        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_CALL, this.getCallOptions()), (Object)request);
        }
    }

    public static final class BenchmarkServiceBlockingStub
    extends AbstractStub<BenchmarkServiceBlockingStub> {
        private BenchmarkServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private BenchmarkServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected BenchmarkServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new BenchmarkServiceBlockingStub(channel, callOptions);
        }

        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest request) {
            return (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_UNARY_CALL, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class BenchmarkServiceStub
    extends AbstractStub<BenchmarkServiceStub> {
        private BenchmarkServiceStub(Channel channel) {
            super(channel);
        }

        private BenchmarkServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected BenchmarkServiceStub build(Channel channel, CallOptions callOptions) {
            return new BenchmarkServiceStub(channel, callOptions);
        }

        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_CALL, this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingCall(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_CALL, this.getCallOptions()), responseObserver);
        }
    }

    public static abstract class BenchmarkServiceImplBase
    implements BindableService {
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_UNARY_CALL, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingCall(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_CALL, responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)BenchmarkServiceGrpc.getServiceDescriptor()).addMethod(METHOD_UNARY_CALL, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(METHOD_STREAMING_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).build();
        }
    }
}

