/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import com.google.protobuf.ByteString;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.TlsChannelCredentials;
import io.grpc.benchmarks.Transport;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.testing.TlsTesting;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.HdrHistogram.Histogram;

public final class Utils {
    private static final String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";
    public static final long HISTOGRAM_MAX_VALUE = 60000000L;
    public static final int HISTOGRAM_PRECISION = 2;
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private static ExecutorService clientExecutor;

    private Utils() {
    }

    public static boolean parseBoolean(String value) {
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    public static SocketAddress parseServerSocketAddress(String value) {
        if (value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            DomainSocketAddress domainAddress = Utils.parseUnixSocketAddress(value);
            File file = new File(domainAddress.path());
            try {
                if (file.createNewFile()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return domainAddress;
        }
        String[] parts = value.split(":", 2);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Address must be a unix:// path or be in the form host:port. Got: " + value);
        }
        String host = parts[0];
        int port = Integer.parseInt(parts[1]);
        return new InetSocketAddress(host, port);
    }

    private static DomainSocketAddress parseUnixSocketAddress(String value) {
        Preconditions.checkArgument((boolean)value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX), (String)"Must start with %s: %s", (Object)UNIX_DOMAIN_SOCKET_PREFIX, (Object)value);
        String filePath = value.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("File path must be absolute: " + filePath);
        }
        return new DomainSocketAddress(file);
    }

    private static NettyChannelBuilder configureNetty(NettyChannelBuilder builder, Transport transport, int flowControlWindow) {
        builder.flowControlWindow(flowControlWindow);
        DefaultThreadFactory tf = new DefaultThreadFactory("client-elg-", true);
        switch (transport) {
            case NETTY_NIO: {
                builder.eventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)tf)).channelType(NioSocketChannel.class);
                break;
            }
            case NETTY_EPOLL: {
                builder.eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)tf)).channelType(EpollSocketChannel.class);
                break;
            }
            case NETTY_UNIX_DOMAIN_SOCKET: {
                builder.eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)tf)).channelType(EpollDomainSocketChannel.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported transport: " + (Object)((Object)transport));
            }
        }
        return builder;
    }

    private static synchronized ExecutorService getExecutor() {
        if (clientExecutor == null) {
            clientExecutor = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
                final AtomicInteger num = new AtomicInteger();

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    thread.setDaemon(true);
                    thread.setName("grpc-client-app--" + this.num.getAndIncrement());
                    return thread;
                }
            }, UncaughtExceptionHandlers.systemExit(), true);
        }
        return clientExecutor;
    }

    public static ManagedChannel newClientChannel(Transport transport, String target, boolean tls, boolean testca, @Nullable String authorityOverride, int flowControlWindow, boolean directExecutor) {
        ChannelCredentials credentials;
        if (tls) {
            if (testca) {
                try {
                    credentials = TlsChannelCredentials.newBuilder().trustManager(TlsTesting.loadCert((String)"ca.pem")).build();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                credentials = TlsChannelCredentials.create();
            }
        } else {
            credentials = InsecureChannelCredentials.create();
        }
        Object builder = transport == Transport.OK_HTTP ? OkHttpChannelBuilder.forTarget((String)target, (ChannelCredentials)credentials).flowControlWindow(flowControlWindow) : (target.startsWith(UNIX_DOMAIN_SOCKET_PREFIX) ? Utils.configureNetty(NettyChannelBuilder.forAddress((SocketAddress)Utils.parseUnixSocketAddress(target), (ChannelCredentials)credentials), transport, flowControlWindow) : Utils.configureNetty(NettyChannelBuilder.forTarget((String)target, (ChannelCredentials)credentials), transport, flowControlWindow));
        if (authorityOverride != null) {
            builder.overrideAuthority(authorityOverride);
        }
        if (directExecutor) {
            builder.directExecutor();
        } else {
            builder.executor((Executor)Utils.getExecutor());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHistogram(Histogram histogram, String filename) throws IOException {
        try (PrintStream log = null;){
            File file = new File(filename);
            if (file.exists() && !file.delete()) {
                System.err.println("Failed deleting previous histogram file: " + file.getAbsolutePath());
            }
            log = new PrintStream(new FileOutputStream(file), false);
            histogram.outputPercentileDistribution(log, Double.valueOf(1.0));
        }
    }

    public static Messages.SimpleResponse makeResponse(Messages.SimpleRequest request) {
        if (request.getResponseSize() > 0) {
            if (!Messages.PayloadType.COMPRESSABLE.equals((Object)request.getResponseType())) {
                throw Status.INTERNAL.augmentDescription("Error creating payload.").asRuntimeException();
            }
            ByteString body = ByteString.copyFrom((byte[])new byte[request.getResponseSize()]);
            Messages.PayloadType type = request.getResponseType();
            Messages.Payload payload = Messages.Payload.newBuilder().setType(type).setBody(body).build();
            return Messages.SimpleResponse.newBuilder().setPayload(payload).build();
        }
        return Messages.SimpleResponse.getDefaultInstance();
    }

    public static Messages.SimpleRequest makeRequest(Messages.PayloadType payloadType, int reqLength, int respLength) {
        ByteString body = ByteString.copyFrom((byte[])new byte[reqLength]);
        Messages.Payload payload = Messages.Payload.newBuilder().setType(payloadType).setBody(body).build();
        return Messages.SimpleRequest.newBuilder().setResponseType(payloadType).setResponseSize(respLength).setPayload(payload).build();
    }

    public static int pickUnusedPort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

