/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import io.grpc.benchmarks.SocketAddressValidator;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.qps.AbstractConfigurationBuilder;
import io.grpc.benchmarks.qps.Configuration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class ServerConfiguration
implements Configuration {
    private static final ServerConfiguration DEFAULT = new ServerConfiguration();
    Transport transport = Transport.NETTY_NIO;
    boolean tls;
    boolean directExecutor;
    SocketAddress address;
    int flowControlWindow = 0x100000;

    private ServerConfiguration() {
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ ServerConfiguration access$400() {
        return DEFAULT;
    }

    static enum ServerParam implements AbstractConfigurationBuilder.Param
    {
        ADDRESS("STR", "Socket address (host:port) or Unix Domain Socket file name (unix:///path/to/file), depending on the transport selected.", null, true){

            @Override
            protected void setServerValue(ServerConfiguration config, String value) {
                SocketAddress address = Utils.parseServerSocketAddress(value);
                if (address instanceof InetSocketAddress) {
                    InetSocketAddress addr = (InetSocketAddress)address;
                    int port = addr.getPort() == 0 ? Utils.pickUnusedPort() : addr.getPort();
                    address = new InetSocketAddress(port);
                }
                config.address = address;
            }
        }
        ,
        TLS("", "Enable TLS.", "" + ServerConfiguration.access$400().tls){

            @Override
            protected void setServerValue(ServerConfiguration config, String value) {
                config.tls = Utils.parseBoolean(value);
            }
        }
        ,
        TRANSPORT("STR", Transport.getDescriptionString(), ServerConfiguration.access$400().transport.toString()){

            @Override
            protected void setServerValue(ServerConfiguration config, String value) {
                config.transport = Transport.valueOf(value.toUpperCase(Locale.ROOT));
            }
        }
        ,
        DIRECTEXECUTOR("", "Don't use a threadpool for RPC calls, instead execute calls directly in the transport thread.", "" + ServerConfiguration.access$400().directExecutor){

            @Override
            protected void setServerValue(ServerConfiguration config, String value) {
                config.directExecutor = Utils.parseBoolean(value);
            }
        }
        ,
        FLOW_CONTROL_WINDOW("BYTES", "The HTTP/2 flow control window.", "" + ServerConfiguration.access$400().flowControlWindow){

            @Override
            protected void setServerValue(ServerConfiguration config, String value) {
                config.flowControlWindow = Integer.parseInt(value);
            }
        };

        private final String type;
        private final String description;
        private final String defaultValue;
        private final boolean required;

        private ServerParam(String type, String description, String defaultValue) {
            this(type, description, defaultValue, false);
        }

        private ServerParam(String type, String description, String defaultValue, boolean required) {
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
            this.required = required;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public void setValue(Configuration config, String value) {
            this.setServerValue((ServerConfiguration)config, value);
        }

        protected abstract void setServerValue(ServerConfiguration var1, String var2);
    }

    public static enum Transport {
        NETTY_NIO(true, "The Netty Java NIO transport. Using this with TLS requires that the Java bootclasspath be configured with Jetty ALPN boot.", SocketAddressValidator.INET),
        NETTY_EPOLL(true, "The Netty native EPOLL transport. Using this with TLS requires that OpenSSL be installed and configured as described in http://netty.io/wiki/forked-tomcat-native.html. Only supported on Linux.", SocketAddressValidator.INET),
        NETTY_UNIX_DOMAIN_SOCKET(false, "The Netty Unix Domain Socket transport. This currently does not support TLS.", SocketAddressValidator.UDS);

        private final boolean tlsSupported;
        private final String description;
        private final SocketAddressValidator socketAddressValidator;

        private Transport(boolean tlsSupported, String description, SocketAddressValidator socketAddressValidator) {
            this.tlsSupported = tlsSupported;
            this.description = description;
            this.socketAddressValidator = socketAddressValidator;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        void validateSocketAddress(SocketAddress address) {
            if (!this.socketAddressValidator.isValidSocketAddress(address)) {
                throw new IllegalArgumentException("Invalid address " + address + " for transport " + (Object)((Object)this));
            }
        }

        static String getDescriptionString() {
            StringBuilder builder = new StringBuilder("Select the transport to use. Options:\n");
            boolean first = true;
            for (Transport transport : Transport.values()) {
                if (!first) {
                    builder.append("\n");
                }
                builder.append((Object)transport);
                builder.append(": ");
                builder.append(transport.description);
                first = false;
            }
            return builder.toString();
        }
    }

    static class Builder
    extends AbstractConfigurationBuilder<ServerConfiguration> {
        private static final List<AbstractConfigurationBuilder.Param> PARAMS = Builder.supportedParams();

        private Builder() {
        }

        @Override
        protected ServerConfiguration newConfiguration() {
            return new ServerConfiguration();
        }

        @Override
        protected Collection<AbstractConfigurationBuilder.Param> getParams() {
            return PARAMS;
        }

        @Override
        protected ServerConfiguration build0(ServerConfiguration config) {
            if (config.tls && !config.transport.tlsSupported) {
                throw new IllegalArgumentException("TLS unsupported with the " + (Object)((Object)config.transport) + " transport");
            }
            config.transport.validateSocketAddress(config.address);
            return config;
        }

        private static List<AbstractConfigurationBuilder.Param> supportedParams() {
            return Collections.unmodifiableList(new ArrayList<ServerParam>(Arrays.asList(ServerParam.values())));
        }
    }
}

