/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.qps;

import com.google.common.util.concurrent.UncaughtExceptionHandlers;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.benchmarks.Utils;
import io.grpc.benchmarks.proto.BenchmarkServiceGrpc;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.qps.ServerConfiguration;
import io.grpc.internal.testing.TestUtils;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.grpc.stub.StreamObservers;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class AsyncServer {
    private static final Logger log = Logger.getLogger(AsyncServer.class.getName());

    public static void main(String ... args) throws Exception {
        new AsyncServer().run(args);
    }

    public void run(String[] args) throws Exception {
        ServerConfiguration config;
        ServerConfiguration.Builder configBuilder = ServerConfiguration.newBuilder();
        try {
            config = (ServerConfiguration)configBuilder.build(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            configBuilder.printUsage();
            return;
        }
        final Server server = AsyncServer.newServer(config);
        server.start();
        System.out.println("QPS Server started on " + config.address);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("QPS Server shutting down");
                    server.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.awaitTermination();
    }

    static Server newServer(ServerConfiguration config) throws IOException {
        Class channelType;
        NioEventLoopGroup worker;
        NioEventLoopGroup boss;
        SslContext sslContext = null;
        if (config.tls) {
            System.out.println("Using fake CA for TLS certificate.\nRun the Java client with --tls --testca");
            File cert = TestUtils.loadCert((String)"server1.pem");
            File key = TestUtils.loadCert((String)"server1.key");
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((File)cert, (File)key);
            sslContextBuilder = config.transport == ServerConfiguration.Transport.NETTY_NIO ? GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.JDK) : GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder, (SslProvider)SslProvider.OPENSSL);
            if (config.useDefaultCiphers) {
                sslContextBuilder.ciphers(null);
            }
            sslContext = sslContextBuilder.build();
        }
        DefaultThreadFactory tf = new DefaultThreadFactory("server-elg-", true);
        switch (config.transport) {
            case NETTY_NIO: {
                boss = new NioEventLoopGroup(1, (ThreadFactory)tf);
                worker = new NioEventLoopGroup(0, (ThreadFactory)tf);
                channelType = NioServerSocketChannel.class;
                break;
            }
            case NETTY_EPOLL: {
                Class<?> groupClass;
                try {
                    groupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                    Class<?> channelClass = Class.forName("io.netty.channel.epoll.EpollServerSocketChannel");
                    boss = (EventLoopGroup)groupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(1, tf);
                    worker = (EventLoopGroup)groupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(0, tf);
                    channelType = channelClass;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case NETTY_UNIX_DOMAIN_SOCKET: {
                Class<?> groupClass;
                try {
                    groupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                    Class<?> channelClass = Class.forName("io.netty.channel.epoll.EpollServerDomainSocketChannel");
                    boss = (EventLoopGroup)groupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(1, tf);
                    worker = (EventLoopGroup)groupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(0, tf);
                    channelType = channelClass;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported transport: " + (Object)((Object)config.transport));
            }
        }
        NettyServerBuilder builder = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)config.address).bossEventLoopGroup((EventLoopGroup)boss).workerEventLoopGroup((EventLoopGroup)worker).channelType(channelType).addService((BindableService)new BenchmarkServiceImpl())).sslContext(sslContext).flowControlWindow(config.flowControlWindow);
        if (config.directExecutor) {
            builder.directExecutor();
        } else {
            builder.executor((Executor)new ForkJoinPool(Runtime.getRuntime().availableProcessors(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
                final AtomicInteger num = new AtomicInteger();

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    thread.setDaemon(true);
                    thread.setName("grpc-server-app--" + this.num.getAndIncrement());
                    return thread;
                }
            }, UncaughtExceptionHandlers.systemExit(), true));
        }
        return builder.build();
    }

    public static class BenchmarkServiceImpl
    extends BenchmarkServiceGrpc.BenchmarkServiceImplBase {
        private static final int BIDI_RESPONSE_BYTES = 100;
        private static final Messages.SimpleResponse BIDI_RESPONSE = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[100])).build()).build();
        private final AtomicBoolean shutdown = new AtomicBoolean();

        public void shutdown() {
            this.shutdown.set(true);
        }

        @Override
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            responseObserver.onNext((Object)Utils.makeResponse(request));
            responseObserver.onCompleted();
        }

        @Override
        public StreamObserver<Messages.SimpleRequest> streamingCall(StreamObserver<Messages.SimpleResponse> observer) {
            final ServerCallStreamObserver responseObserver = (ServerCallStreamObserver)observer;
            return new StreamObserver<Messages.SimpleRequest>(){

                public void onNext(Messages.SimpleRequest value) {
                    if (BenchmarkServiceImpl.this.shutdown.get()) {
                        responseObserver.onCompleted();
                        return;
                    }
                    responseObserver.onNext((Object)Utils.makeResponse(value));
                }

                public void onError(Throwable t) {
                    responseObserver.onError(t);
                }

                public void onCompleted() {
                    responseObserver.onCompleted();
                }
            };
        }

        @Override
        public StreamObserver<Messages.SimpleRequest> streamingFromClient(final StreamObserver<Messages.SimpleResponse> responseObserver) {
            return new StreamObserver<Messages.SimpleRequest>(){
                Messages.SimpleRequest lastSeen = null;

                public void onNext(Messages.SimpleRequest value) {
                    if (BenchmarkServiceImpl.this.shutdown.get()) {
                        responseObserver.onCompleted();
                        return;
                    }
                    this.lastSeen = value;
                }

                public void onError(Throwable t) {
                    responseObserver.onError(t);
                }

                public void onCompleted() {
                    if (this.lastSeen != null) {
                        responseObserver.onNext((Object)Utils.makeResponse(this.lastSeen));
                        responseObserver.onCompleted();
                    } else {
                        responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription("never received any requests").asException());
                    }
                }
            };
        }

        @Override
        public void streamingFromServer(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> observer) {
            final Messages.SimpleResponse response = Utils.makeResponse(request);
            final ServerCallStreamObserver responseObserver = (ServerCallStreamObserver)observer;
            StreamObservers.copyWithFlowControl((Iterator)new Iterator<Messages.SimpleResponse>(){

                @Override
                public boolean hasNext() {
                    return !BenchmarkServiceImpl.this.shutdown.get() && !responseObserver.isCancelled();
                }

                @Override
                public Messages.SimpleResponse next() {
                    return response;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, (CallStreamObserver)responseObserver);
        }

        @Override
        public StreamObserver<Messages.SimpleRequest> streamingBothWays(StreamObserver<Messages.SimpleResponse> observer) {
            final ServerCallStreamObserver responseObserver = (ServerCallStreamObserver)observer;
            StreamObservers.copyWithFlowControl((Iterator)new Iterator<Messages.SimpleResponse>(){

                @Override
                public boolean hasNext() {
                    return !BenchmarkServiceImpl.this.shutdown.get() && !responseObserver.isCancelled();
                }

                @Override
                public Messages.SimpleResponse next() {
                    return BIDI_RESPONSE;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, (CallStreamObserver)responseObserver);
            return new StreamObserver<Messages.SimpleRequest>(){

                public void onNext(Messages.SimpleRequest request) {
                }

                public void onError(Throwable t) {
                }

                public void onCompleted() {
                    log.severe("clients should CANCEL the call to stop bidi streaming");
                }
            };
        }
    }
}

