/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.benchmarks.proto;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.benchmarks.proto.Messages;
import io.grpc.benchmarks.proto.Services;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

public final class BenchmarkServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.BenchmarkService";
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_UNARY_CALL = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"UnaryCall")).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new BenchmarkServiceMethodDescriptorSupplier("UnaryCall")).build();
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_STREAMING_CALL = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"StreamingCall")).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new BenchmarkServiceMethodDescriptorSupplier("StreamingCall")).build();
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_STREAMING_FROM_CLIENT = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"StreamingFromClient")).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new BenchmarkServiceMethodDescriptorSupplier("StreamingFromClient")).build();
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_STREAMING_FROM_SERVER = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"StreamingFromServer")).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new BenchmarkServiceMethodDescriptorSupplier("StreamingFromServer")).build();
    public static final MethodDescriptor<Messages.SimpleRequest, Messages.SimpleResponse> METHOD_STREAMING_BOTH_WAYS = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.BenchmarkService", (String)"StreamingBothWays")).setRequestMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Messages.SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new BenchmarkServiceMethodDescriptorSupplier("StreamingBothWays")).build();
    private static final int METHODID_UNARY_CALL = 0;
    private static final int METHODID_STREAMING_FROM_SERVER = 1;
    private static final int METHODID_STREAMING_CALL = 2;
    private static final int METHODID_STREAMING_FROM_CLIENT = 3;
    private static final int METHODID_STREAMING_BOTH_WAYS = 4;
    private static volatile ServiceDescriptor serviceDescriptor;

    private BenchmarkServiceGrpc() {
    }

    public static BenchmarkServiceStub newStub(Channel channel) {
        return new BenchmarkServiceStub(channel);
    }

    public static BenchmarkServiceBlockingStub newBlockingStub(Channel channel) {
        return new BenchmarkServiceBlockingStub(channel);
    }

    public static BenchmarkServiceFutureStub newFutureStub(Channel channel) {
        return new BenchmarkServiceFutureStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<BenchmarkServiceGrpc> clazz = BenchmarkServiceGrpc.class;
        synchronized (BenchmarkServiceGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new BenchmarkServiceFileDescriptorSupplier()).addMethod(METHOD_UNARY_CALL).addMethod(METHOD_STREAMING_CALL).addMethod(METHOD_STREAMING_FROM_CLIENT).addMethod(METHOD_STREAMING_FROM_SERVER).addMethod(METHOD_STREAMING_BOTH_WAYS).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class BenchmarkServiceMethodDescriptorSupplier
    extends BenchmarkServiceBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        BenchmarkServiceMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class BenchmarkServiceFileDescriptorSupplier
    extends BenchmarkServiceBaseDescriptorSupplier {
        BenchmarkServiceFileDescriptorSupplier() {
        }
    }

    private static abstract class BenchmarkServiceBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        BenchmarkServiceBaseDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return Services.getDescriptor();
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName("BenchmarkService");
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final BenchmarkServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(BenchmarkServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.unaryCall((Messages.SimpleRequest)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.streamingFromServer((Messages.SimpleRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    return this.serviceImpl.streamingCall(responseObserver);
                }
                case 3: {
                    return this.serviceImpl.streamingFromClient(responseObserver);
                }
                case 4: {
                    return this.serviceImpl.streamingBothWays(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class BenchmarkServiceFutureStub
    extends AbstractStub<BenchmarkServiceFutureStub> {
        private BenchmarkServiceFutureStub(Channel channel) {
            super(channel);
        }

        private BenchmarkServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected BenchmarkServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new BenchmarkServiceFutureStub(channel, callOptions);
        }

        public ListenableFuture<Messages.SimpleResponse> unaryCall(Messages.SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_CALL, this.getCallOptions()), (Object)request);
        }
    }

    public static final class BenchmarkServiceBlockingStub
    extends AbstractStub<BenchmarkServiceBlockingStub> {
        private BenchmarkServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private BenchmarkServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected BenchmarkServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new BenchmarkServiceBlockingStub(channel, callOptions);
        }

        public Messages.SimpleResponse unaryCall(Messages.SimpleRequest request) {
            return (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_UNARY_CALL, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Iterator<Messages.SimpleResponse> streamingFromServer(Messages.SimpleRequest request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), METHOD_STREAMING_FROM_SERVER, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class BenchmarkServiceStub
    extends AbstractStub<BenchmarkServiceStub> {
        private BenchmarkServiceStub(Channel channel) {
            super(channel);
        }

        private BenchmarkServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected BenchmarkServiceStub build(Channel channel, CallOptions callOptions) {
            return new BenchmarkServiceStub(channel, callOptions);
        }

        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_CALL, this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingCall(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_CALL, this.getCallOptions()), responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingFromClient(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ClientCalls.asyncClientStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_FROM_CLIENT, this.getCallOptions()), responseObserver);
        }

        public void streamingFromServer(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_FROM_SERVER, this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingBothWays(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_STREAMING_BOTH_WAYS, this.getCallOptions()), responseObserver);
        }
    }

    public static abstract class BenchmarkServiceImplBase
    implements BindableService {
        public void unaryCall(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_UNARY_CALL, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingCall(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_CALL, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingFromClient(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_FROM_CLIENT, responseObserver);
        }

        public void streamingFromServer(Messages.SimpleRequest request, StreamObserver<Messages.SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_STREAMING_FROM_SERVER, responseObserver);
        }

        public StreamObserver<Messages.SimpleRequest> streamingBothWays(StreamObserver<Messages.SimpleResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_BOTH_WAYS, responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)BenchmarkServiceGrpc.getServiceDescriptor()).addMethod(METHOD_UNARY_CALL, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(METHOD_STREAMING_CALL, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 2))).addMethod(METHOD_STREAMING_FROM_CLIENT, ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 3))).addMethod(METHOD_STREAMING_FROM_SERVER, ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 1))).addMethod(METHOD_STREAMING_BOTH_WAYS, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 4))).build();
        }
    }
}

