/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.ServerStreamTracer;
import io.grpc.binder.AndroidComponentAddress;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.ServerSecurityPolicy;
import io.grpc.binder.internal.BinderTransport;
import io.grpc.binder.internal.BinderTransportSecurity;
import io.grpc.binder.internal.BoundClientAddress;
import io.grpc.binder.internal.LeakSafeOneWayBinder;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransport;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BinderServer
implements InternalServer,
LeakSafeOneWayBinder.TransactionHandler {
    private final ObjectPool<ScheduledExecutorService> executorServicePool;
    private final ImmutableList<ServerStreamTracer.Factory> streamTracerFactories;
    private final AndroidComponentAddress listenAddress;
    private final LeakSafeOneWayBinder hostServiceBinder;
    private final ServerSecurityPolicy serverSecurityPolicy;
    private final InboundParcelablePolicy inboundParcelablePolicy;
    @GuardedBy(value="this")
    private ServerListener listener;
    @GuardedBy(value="this")
    private ScheduledExecutorService executorService;
    @GuardedBy(value="this")
    private boolean shutdown;

    public BinderServer(AndroidComponentAddress listenAddress, ObjectPool<ScheduledExecutorService> executorServicePool, List<? extends ServerStreamTracer.Factory> streamTracerFactories, ServerSecurityPolicy serverSecurityPolicy, InboundParcelablePolicy inboundParcelablePolicy) {
        this.listenAddress = listenAddress;
        this.executorServicePool = executorServicePool;
        this.streamTracerFactories = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories")));
        this.serverSecurityPolicy = (ServerSecurityPolicy)Preconditions.checkNotNull((Object)serverSecurityPolicy, (Object)"serverSecurityPolicy");
        this.inboundParcelablePolicy = inboundParcelablePolicy;
        this.hostServiceBinder = new LeakSafeOneWayBinder(this);
    }

    public IBinder getHostBinder() {
        return this.hostServiceBinder;
    }

    public synchronized void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        this.executorService = (ScheduledExecutorService)this.executorServicePool.getObject();
    }

    public SocketAddress getListenSocketAddress() {
        return this.listenAddress;
    }

    public List<? extends SocketAddress> getListenSocketAddresses() {
        return ImmutableList.of((Object)this.listenAddress);
    }

    public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
        return null;
    }

    @Nullable
    public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
        return null;
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.hostServiceBinder.detach();
            this.listener.serverShutdown();
            this.executorService = (ScheduledExecutorService)this.executorServicePool.returnObject((Object)this.executorService);
        }
    }

    public String toString() {
        return "BinderServer[" + this.listenAddress + "]";
    }

    @Override
    public synchronized boolean handleTransaction(int code, Parcel parcel) {
        IBinder callbackBinder;
        int version;
        if (code == 1 && (version = parcel.readInt()) >= 1 && (callbackBinder = parcel.readStrongBinder()) != null) {
            int callingUid = Binder.getCallingUid();
            Attributes.Builder attrsBuilder = Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)this.listenAddress).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)new BoundClientAddress(callingUid)).set(BinderTransport.REMOTE_UID, (Object)callingUid).set(BinderTransport.SERVER_AUTHORITY, (Object)this.listenAddress.getAuthority()).set(BinderTransport.INBOUND_PARCELABLE_POLICY, (Object)this.inboundParcelablePolicy);
            BinderTransportSecurity.attachAuthAttrs(attrsBuilder, callingUid, this.serverSecurityPolicy);
            BinderTransport.BinderServerTransport transport = new BinderTransport.BinderServerTransport(this.executorServicePool, attrsBuilder.build(), (List<ServerStreamTracer.Factory>)this.streamTracerFactories, callbackBinder);
            transport.setServerTransportListener(this.listener.transportCreated((ServerTransport)transport));
            return true;
        }
        return false;
    }
}

