/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import com.google.common.primitives.Ints;
import io.grpc.Drainable;
import io.grpc.KnownLength;
import io.grpc.binder.internal.BlockPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class BlockInputStream
extends InputStream
implements KnownLength,
Drainable {
    @Nullable
    private byte[][] blocks;
    @Nullable
    private byte[] currentBlock;
    private int blockIndex;
    private int blockOffset;
    private int available;
    private boolean closed;

    BlockInputStream(byte[] block) {
        this.blocks = null;
        this.currentBlock = (byte[])(block.length > 0 ? block : null);
        this.available = block.length;
    }

    BlockInputStream(byte[][] blocks, int available) {
        this.blocks = blocks;
        this.available = available;
        if (blocks.length > 0) {
            this.currentBlock = blocks[0];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentBlock != null) {
            byte res = this.currentBlock[this.blockOffset++];
            --this.available;
            if (this.blockOffset == this.currentBlock.length) {
                this.nextBlock();
            }
            return res;
        }
        return -1;
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        int bytesRead;
        int stillToRead = len;
        while (this.currentBlock != null) {
            int n = Ints.min((int[])new int[]{stillToRead, this.currentBlock.length - this.blockOffset, this.available});
            System.arraycopy(this.currentBlock, this.blockOffset, data, off, n);
            off += n;
            this.available -= n;
            if ((stillToRead -= n) == 0) {
                this.blockOffset += n;
                if (this.blockOffset != this.currentBlock.length) break;
                this.nextBlock();
                break;
            }
            this.nextBlock();
        }
        if ((bytesRead = len - stillToRead) > 0 || this.available > 0) {
            return bytesRead;
        }
        return -1;
    }

    private void nextBlock() {
        ++this.blockIndex;
        this.blockOffset = 0;
        this.currentBlock = (byte[])(this.blocks != null && this.blockIndex < this.blocks.length ? this.blocks[this.blockIndex] : null);
    }

    @Override
    public int available() {
        return this.available;
    }

    public int drainTo(OutputStream output) throws IOException {
        int res = this.available;
        while (this.available > 0) {
            int n = Math.min(this.currentBlock.length - this.blockOffset, this.available);
            output.write(this.currentBlock, this.blockOffset, n);
            this.available -= n;
            this.nextBlock();
        }
        return res;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.blocks != null) {
                for (byte[] block : this.blocks) {
                    BlockPool.releaseBlock(block);
                }
            } else if (this.currentBlock != null) {
                BlockPool.releaseBlock(this.currentBlock);
            }
            this.currentBlock = null;
            this.blocks = null;
        }
    }
}

