/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import javax.annotation.concurrent.GuardedBy;

final class FlowController {
    private final int maxUnackedBytes;
    @GuardedBy(value="this")
    private long totalBytesSent;
    @GuardedBy(value="this")
    private long totalBytesAckedByPeer;
    private volatile boolean transmitWindowFull;

    public FlowController(int maxUnackedBytes) {
        this.maxUnackedBytes = maxUnackedBytes;
    }

    public boolean isTransmitWindowFull() {
        return this.transmitWindowFull;
    }

    public synchronized boolean notifyBytesSent(long numBytesSent) {
        this.totalBytesSent += numBytesSent;
        if (this.totalBytesSent - this.totalBytesAckedByPeer >= (long)this.maxUnackedBytes && !this.transmitWindowFull) {
            this.transmitWindowFull = true;
            return true;
        }
        return false;
    }

    public synchronized boolean handleAcknowledgedBytes(long numBytesAcked) {
        this.totalBytesAckedByPeer = FlowController.wrapAwareMax(this.totalBytesAckedByPeer, numBytesAcked);
        if (this.totalBytesSent - this.totalBytesAckedByPeer < (long)this.maxUnackedBytes && this.transmitWindowFull) {
            this.transmitWindowFull = false;
            return true;
        }
        return false;
    }

    private static final long wrapAwareMax(long a, long b) {
        return a - b < 0L ? b : a;
    }
}

