/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.AndroidRuntimeException;
import io.grpc.Attributes;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.internal.BinderTransport;
import io.grpc.binder.internal.BlockPool;
import io.grpc.binder.internal.ParcelableInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public final class MetadataHelper {
    private static final Metadata.BinaryStreamMarshaller<Parcelable> TRANSPORT_INBOUND_MARSHALLER = new ParcelableMetadataMarshaller<Parcelable>(null, true);
    private static final int PARCELABLE_SENTINEL = -1;

    private MetadataHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetadata(Parcel parcel, @Nullable Metadata metadata) throws StatusException, IOException {
        int n;
        int n2 = n = metadata != null ? InternalMetadata.headerCount((Metadata)metadata) : 0;
        if (n == 0) {
            parcel.writeInt(0);
            return;
        }
        Object[] serialized = InternalMetadata.serializePartial((Metadata)metadata);
        parcel.writeInt(n);
        for (int i = 0; i < n; ++i) {
            byte[] name = (byte[])serialized[i * 2];
            parcel.writeInt(name.length);
            parcel.writeByteArray(name);
            Object value = serialized[i * 2 + 1];
            if (value instanceof byte[]) {
                byte[] valueBytes = (byte[])value;
                parcel.writeInt(valueBytes.length);
                parcel.writeByteArray(valueBytes);
                continue;
            }
            if (value instanceof ParcelableInputStream) {
                parcel.writeInt(-1);
                ((ParcelableInputStream)value).writeToParcel(parcel);
                continue;
            }
            byte[] buffer = BlockPool.acquireBlock();
            try {
                int total;
                int read;
                InputStream stream = (InputStream)value;
                for (total = 0; total < buffer.length && (read = stream.read(buffer, total, buffer.length - total)) != -1; total += read) {
                }
                if (total == buffer.length) {
                    throw Status.RESOURCE_EXHAUSTED.withDescription("Metadata value too large").asException();
                }
                parcel.writeInt(total);
                if (total <= 0) continue;
                parcel.writeByteArray(buffer, 0, total);
                continue;
            }
            finally {
                BlockPool.releaseBlock(buffer);
            }
        }
    }

    public static Metadata readMetadata(Parcel parcel, Attributes attributes) throws StatusException {
        int n = parcel.readInt();
        if (n == 0) {
            return new Metadata();
        }
        int bytesRead = 0;
        int parcelableBytesRead = 0;
        Object[] serialized = new Object[n * 2];
        for (int i = 0; i < n; ++i) {
            int numNameBytes = parcel.readInt();
            byte[] name = MetadataHelper.readBytesChecked(parcel, numNameBytes, bytesRead += 4);
            bytesRead += numNameBytes;
            serialized[i * 2] = name;
            int numValueBytes = parcel.readInt();
            bytesRead += 4;
            if (numValueBytes == -1) {
                InboundParcelablePolicy policy = (InboundParcelablePolicy)attributes.get(BinderTransport.INBOUND_PARCELABLE_POLICY);
                if (!policy.shouldAcceptParcelableMetadataValues()) {
                    throw Status.PERMISSION_DENIED.withDescription("Parcelable metadata values not allowed").asException();
                }
                int parcelableStartPos = parcel.dataPosition();
                try {
                    Parcelable value = parcel.readParcelable(MetadataHelper.class.getClassLoader());
                    if (value == null) {
                        throw Status.INTERNAL.withDescription("Read null parcelable in metadata").asException();
                    }
                    serialized[i * 2 + 1] = InternalMetadata.parsedValue(TRANSPORT_INBOUND_MARSHALLER, (Object)value);
                }
                catch (AndroidRuntimeException are) {
                    throw Status.INTERNAL.withCause((Throwable)are).withDescription("Failure reading parcelable in metadata").asException();
                }
                int parcelableSize = parcel.dataPosition() - parcelableStartPos;
                if ((parcelableBytesRead += parcelableSize) <= policy.getMaxParcelableMetadataSize()) continue;
                throw Status.RESOURCE_EXHAUSTED.withDescription("Inbound Parcelables too large according to policy (see InboundParcelablePolicy)").asException();
            }
            if (numValueBytes < 0) {
                throw Status.INTERNAL.withDescription("Unrecognized metadata sentinel").asException();
            }
            byte[] value = MetadataHelper.readBytesChecked(parcel, numValueBytes, bytesRead);
            bytesRead += numValueBytes;
            serialized[i * 2 + 1] = value;
        }
        return InternalMetadata.newMetadataWithParsedValues((int)n, (Object[])serialized);
    }

    private static byte[] readBytesChecked(Parcel parcel, int numBytes, int bytesRead) throws StatusException {
        if (bytesRead + numBytes > 8192) {
            throw Status.RESOURCE_EXHAUSTED.withDescription("Metadata too large").asException();
        }
        byte[] res = new byte[numBytes];
        if (numBytes > 0) {
            parcel.readByteArray(res);
        }
        return res;
    }

    public static final class ParcelableMetadataMarshaller<P extends Parcelable>
    implements Metadata.BinaryStreamMarshaller<P> {
        @Nullable
        private final Parcelable.Creator<P> creator;
        private final boolean immutableType;

        public ParcelableMetadataMarshaller(@Nullable Parcelable.Creator<P> creator, boolean immutableType) {
            this.creator = creator;
            this.immutableType = immutableType;
        }

        public InputStream toStream(P value) {
            return new ParcelableInputStream<P>(this.creator, value, this.immutableType);
        }

        public P parseStream(InputStream stream) {
            if (stream instanceof ParcelableInputStream) {
                return ((ParcelableInputStream)stream).getParcelable();
            }
            throw new UnsupportedOperationException("Can't unmarshall a parcelable from a regular byte stream");
        }
    }
}

