/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import io.grpc.Attributes;
import io.grpc.Compressor;
import io.grpc.Deadline;
import io.grpc.DecompressorRegistry;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.internal.Inbound;
import io.grpc.binder.internal.Outbound;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.InsightBuilder;
import java.io.InputStream;
import javax.annotation.Nonnull;

final class MultiMessageClientStream
implements ClientStream {
    private final Inbound.ClientInbound inbound;
    private final Outbound.ClientOutbound outbound;
    private final Attributes attributes;

    MultiMessageClientStream(Inbound.ClientInbound inbound, Outbound.ClientOutbound outbound, Attributes attributes) {
        this.inbound = inbound;
        this.outbound = outbound;
        this.attributes = attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientStreamListener listener) {
        Object object = this.inbound;
        synchronized (object) {
            this.inbound.init(this.outbound, listener);
        }
        if (this.outbound.isReady()) {
            listener.onReady();
        }
        try {
            object = this.outbound;
            synchronized (object) {
                this.outbound.onPrefixReady();
                this.outbound.send();
            }
        }
        catch (StatusException se) {
            Inbound.ClientInbound clientInbound = this.inbound;
            synchronized (clientInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(int numMessages) {
        Inbound.ClientInbound clientInbound = this.inbound;
        synchronized (clientInbound) {
            this.inbound.requestMessages(numMessages);
        }
    }

    public boolean isReady() {
        return this.outbound.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(InputStream message) {
        try {
            Outbound.ClientOutbound clientOutbound = this.outbound;
            synchronized (clientOutbound) {
                this.outbound.addMessage(message);
                this.outbound.send();
            }
        }
        catch (StatusException se) {
            Inbound.ClientInbound clientInbound = this.inbound;
            synchronized (clientInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halfClose() {
        try {
            Outbound.ClientOutbound clientOutbound = this.outbound;
            synchronized (clientOutbound) {
                this.outbound.sendHalfClose();
            }
        }
        catch (StatusException se) {
            Inbound.ClientInbound clientInbound = this.inbound;
            synchronized (clientInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Status status) {
        Inbound.ClientInbound clientInbound = this.inbound;
        synchronized (clientInbound) {
            this.inbound.closeOnCancel(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeadline(@Nonnull Deadline deadline) {
        Outbound.ClientOutbound clientOutbound = this.outbound;
        synchronized (clientOutbound) {
            this.outbound.setDeadline(deadline);
        }
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public final String toString() {
        return "MultiMessageClientStream[" + this.inbound + "/" + this.outbound + "]";
    }

    public final void flush() {
    }

    public final void setCompressor(Compressor compressor) {
    }

    public final void setMessageCompression(boolean enable) {
    }

    public void setAuthority(String authority) {
    }

    public void setMaxInboundMessageSize(int maxSize) {
    }

    public void setMaxOutboundMessageSize(int maxSize) {
    }

    public void appendTimeoutInsight(InsightBuilder insight) {
    }

    public void setFullStreamDecompression(boolean fullStreamDecompression) {
    }

    public void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
    }

    public void optimizeForDirectExecutor() {
    }
}

