/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Parcel;
import com.google.common.base.Preconditions;
import io.grpc.Deadline;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.internal.BinderTransport;
import io.grpc.binder.internal.BlockPool;
import io.grpc.binder.internal.MetadataHelper;
import io.grpc.binder.internal.ParcelHolder;
import io.grpc.binder.internal.ParcelableInputStream;
import io.grpc.binder.internal.TransactionUtils;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.StatsTraceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class Outbound {
    private final BinderTransport transport;
    private final int callId;
    private final StatsTraceContext statsTraceContext;
    @GuardedBy(value="this")
    private State outboundState = State.INITIAL;
    private boolean prefixReady;
    @Nullable
    private InputStream firstMessage;
    @Nullable
    private Queue<InputStream> messageQueue;
    private boolean suffixReady;
    @GuardedBy(value="this")
    private int transactionIndex;
    private int numDeliveredMessages;
    private int messageSize;

    private Outbound(BinderTransport transport, int callId, StatsTraceContext statsTraceContext) {
        this.transport = transport;
        this.callId = callId;
        this.statsTraceContext = statsTraceContext;
    }

    final StatsTraceContext getStatsTraceContext() {
        return this.statsTraceContext;
    }

    @GuardedBy(value="this")
    final void addMessage(InputStream message) throws StatusException {
        this.onPrefixReady();
        if (this.messageQueue != null) {
            this.messageQueue.add(message);
        } else if (this.firstMessage == null) {
            this.firstMessage = message;
        } else {
            this.messageQueue = new ConcurrentLinkedQueue<InputStream>();
            this.messageQueue.add(message);
        }
    }

    @GuardedBy(value="this")
    protected final void onPrefixReady() {
        this.prefixReady = true;
    }

    @GuardedBy(value="this")
    protected final void onSuffixReady() {
        this.suffixReady = true;
    }

    @GuardedBy(value="this")
    private void onOutboundState(State outboundState) {
        Outbound.checkTransition(this.outboundState, outboundState);
        this.outboundState = outboundState;
    }

    @GuardedBy(value="this")
    protected final boolean messageAvailable() {
        if (this.messageQueue != null) {
            return !this.messageQueue.isEmpty();
        }
        if (this.firstMessage != null) {
            return this.numDeliveredMessages == 0;
        }
        return false;
    }

    @Nullable
    @GuardedBy(value="this")
    private final InputStream peekNextMessage() {
        if (this.numDeliveredMessages == 0) {
            return this.firstMessage;
        }
        if (this.messageQueue != null) {
            return this.messageQueue.peek();
        }
        return null;
    }

    @GuardedBy(value="this")
    private final boolean canSend() {
        switch (this.outboundState) {
            case INITIAL: {
                if (this.prefixReady) break;
                return false;
            }
            case PREFIX_SENT: {
                if (this.messageAvailable() || this.suffixReady) break;
                return false;
            }
            case ALL_MESSAGES_SENT: {
                if (this.suffixReady) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return this.isReady();
    }

    final boolean isReady() {
        return this.transport.isReady();
    }

    @GuardedBy(value="this")
    final void onTransportReady() throws StatusException {
        this.send();
    }

    @GuardedBy(value="this")
    final void send() throws StatusException {
        while (this.canSend()) {
            try {
                this.sendInternal();
            }
            catch (StatusException se) {
                this.onOutboundState(State.CLOSED);
                throw se;
            }
        }
    }

    @GuardedBy(value="this")
    protected final void sendInternal() throws StatusException {
        try (ParcelHolder parcel = ParcelHolder.obtain();){
            int flags = 0;
            parcel.get().writeInt(0);
            parcel.get().writeInt(this.transactionIndex++);
            switch (this.outboundState) {
                case INITIAL: {
                    flags |= 1;
                    flags |= this.writePrefix(parcel.get());
                    this.onOutboundState(State.PREFIX_SENT);
                    if (!this.messageAvailable() && !this.suffixReady) break;
                }
                case PREFIX_SENT: {
                    InputStream messageStream = this.peekNextMessage();
                    if (messageStream != null) {
                        flags |= 2;
                        flags |= this.writeMessageData(parcel.get(), messageStream);
                    } else {
                        Preconditions.checkState((boolean)this.suffixReady);
                    }
                    if (!this.suffixReady || this.messageAvailable()) break;
                    this.onOutboundState(State.ALL_MESSAGES_SENT);
                }
                case ALL_MESSAGES_SENT: {
                    flags |= 4;
                    flags |= this.writeSuffix(parcel.get());
                    this.onOutboundState(State.SUFFIX_SENT);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            TransactionUtils.fillInFlags(parcel.get(), flags);
            int dataSize = parcel.get().dataSize();
            this.transport.sendTransaction(this.callId, parcel);
            this.statsTraceContext.outboundWireSize((long)dataSize);
            this.statsTraceContext.outboundUncompressedSize((long)dataSize);
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asException();
        }
    }

    protected final void unregister() {
        this.transport.unregisterCall(this.callId);
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[S=" + (Object)((Object)this.outboundState) + "/NDM=" + this.numDeliveredMessages + "]";
    }

    @GuardedBy(value="this")
    protected abstract int writePrefix(Parcel var1) throws IOException, StatusException;

    @GuardedBy(value="this")
    protected abstract int writeSuffix(Parcel var1) throws IOException, StatusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private final int writeMessageData(Parcel parcel, InputStream stream) throws IOException {
        int flags = 0;
        boolean dataRemaining = false;
        if (stream instanceof ParcelableInputStream) {
            flags |= 0x40;
            this.messageSize = ((ParcelableInputStream)stream).writeToParcel(parcel);
        } else {
            byte[] block = BlockPool.acquireBlock();
            try {
                int size = stream.read(block);
                if (size <= 0) {
                    parcel.writeInt(0);
                } else {
                    parcel.writeInt(size);
                    parcel.writeByteArray(block, 0, size);
                    this.messageSize += size;
                    if (size == block.length) {
                        flags |= 0x80;
                        dataRemaining = true;
                    }
                }
            }
            finally {
                BlockPool.releaseBlock(block);
            }
        }
        if (!dataRemaining) {
            stream.close();
            int index = this.numDeliveredMessages++;
            if (index > 0) {
                ((Queue)Preconditions.checkNotNull(this.messageQueue)).poll();
            }
            this.statsTraceContext.outboundMessage(index);
            this.statsTraceContext.outboundMessageSent(index, (long)this.messageSize, (long)this.messageSize);
            this.messageSize = 0;
        }
        return flags;
    }

    private static void checkTransition(State current, State next) {
        switch (next) {
            case PREFIX_SENT: {
                Preconditions.checkState((current == State.INITIAL ? 1 : 0) != 0);
                break;
            }
            case ALL_MESSAGES_SENT: {
                Preconditions.checkState((current == State.PREFIX_SENT ? 1 : 0) != 0);
                break;
            }
            case SUFFIX_SENT: {
                Preconditions.checkState((current == State.ALL_MESSAGES_SENT ? 1 : 0) != 0);
                break;
            }
            case CLOSED: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    static final class ServerOutbound
    extends Outbound {
        @Nullable
        @GuardedBy(value="this")
        private Metadata headers;
        @Nullable
        @GuardedBy(value="this")
        private Status closeStatus;
        @Nullable
        @GuardedBy(value="this")
        private Metadata trailers;

        ServerOutbound(BinderTransport transport, int callId, StatsTraceContext statsTraceContext) {
            super(transport, callId, statsTraceContext);
        }

        @GuardedBy(value="this")
        void sendHeaders(Metadata headers) throws StatusException {
            this.headers = headers;
            this.onPrefixReady();
            this.send();
        }

        @Override
        @GuardedBy(value="this")
        protected int writePrefix(Parcel parcel) throws IOException, StatusException {
            MetadataHelper.writeMetadata(parcel, this.headers);
            return 0;
        }

        @GuardedBy(value="this")
        void sendSingleMessageAndClose(@Nullable Metadata pendingHeaders, @Nullable InputStream pendingSingleMessage, Status closeStatus, Metadata trailers) throws StatusException {
            if (this.closeStatus != null) {
                return;
            }
            if (pendingHeaders != null) {
                this.headers = pendingHeaders;
            }
            this.onPrefixReady();
            if (pendingSingleMessage != null) {
                this.addMessage(pendingSingleMessage);
            }
            Preconditions.checkState((this.trailers == null ? 1 : 0) != 0);
            this.closeStatus = closeStatus;
            this.trailers = trailers;
            this.onSuffixReady();
            this.send();
        }

        @GuardedBy(value="this")
        void sendClose(Status closeStatus, Metadata trailers) throws StatusException {
            if (this.closeStatus != null) {
                return;
            }
            Preconditions.checkState((this.trailers == null ? 1 : 0) != 0);
            this.closeStatus = closeStatus;
            this.trailers = trailers;
            this.onPrefixReady();
            this.onSuffixReady();
            this.send();
        }

        @Override
        @GuardedBy(value="this")
        protected int writeSuffix(Parcel parcel) throws IOException, StatusException {
            int flags = TransactionUtils.writeStatus(parcel, this.closeStatus);
            MetadataHelper.writeMetadata(parcel, this.trailers);
            this.unregister();
            return flags;
        }
    }

    static final class ClientOutbound
    extends Outbound {
        private final MethodDescriptor<?, ?> method;
        private final Metadata headers;
        private final StatsTraceContext statsTraceContext;

        ClientOutbound(BinderTransport transport, int callId, MethodDescriptor<?, ?> method, Metadata headers, StatsTraceContext statsTraceContext) {
            super(transport, callId, statsTraceContext);
            this.method = method;
            this.headers = headers;
            this.statsTraceContext = statsTraceContext;
        }

        @Override
        @GuardedBy(value="this")
        protected int writePrefix(Parcel parcel) throws IOException, StatusException {
            parcel.writeString(this.method.getFullMethodName());
            MetadataHelper.writeMetadata(parcel, this.headers);
            this.statsTraceContext.clientOutboundHeaders();
            if (this.method.getType().serverSendsOneMessage()) {
                return 16;
            }
            return 0;
        }

        @GuardedBy(value="this")
        void sendSingleMessageAndHalfClose(@Nullable InputStream singleMessage) throws StatusException {
            if (singleMessage != null) {
                this.addMessage(singleMessage);
            }
            this.onSuffixReady();
            this.send();
        }

        @GuardedBy(value="this")
        void sendHalfClose() throws StatusException {
            this.onSuffixReady();
            this.send();
        }

        @Override
        @GuardedBy(value="this")
        protected int writeSuffix(Parcel parcel) throws IOException {
            return 0;
        }

        @GuardedBy(value="this")
        void setDeadline(Deadline deadline) {
            this.headers.discardAll(GrpcUtil.TIMEOUT_KEY);
            long effectiveTimeoutNanos = Math.max(0L, deadline.timeRemaining(TimeUnit.NANOSECONDS));
            this.headers.put(GrpcUtil.TIMEOUT_KEY, (Object)effectiveTimeoutNanos);
        }
    }

    static enum State {
        INITIAL,
        PREFIX_SENT,
        ALL_MESSAGES_SENT,
        SUFFIX_SENT,
        CLOSED;

    }
}

