/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import com.google.common.base.Ticker;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.internal.ClientTransport;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class PingTracker {
    private final Ticker ticker;
    private final PingSender pingSender;
    @Nullable
    @GuardedBy(value="this")
    private Ping pendingPing;
    @GuardedBy(value="this")
    private int nextPingId;

    PingTracker(Ticker ticker, PingSender pingSender) {
        this.ticker = ticker;
        this.pingSender = pingSender;
    }

    synchronized void startPing(ClientTransport.PingCallback callback, Executor executor) {
        this.pendingPing = new Ping(callback, executor, this.nextPingId++);
        try {
            this.pingSender.sendPing(this.pendingPing.id);
        }
        catch (StatusException se) {
            this.pendingPing.fail(se.getStatus());
            this.pendingPing = null;
        }
    }

    synchronized void onPingResponse(int id) {
        if (this.pendingPing != null && this.pendingPing.id == id) {
            this.pendingPing.success();
            this.pendingPing = null;
        }
    }

    private final class Ping {
        private final ClientTransport.PingCallback callback;
        private final Executor executor;
        private final int id;
        private final long startTimeNanos;
        @GuardedBy(value="this")
        private boolean done;

        Ping(ClientTransport.PingCallback callback, Executor executor, int id) {
            this.callback = callback;
            this.executor = executor;
            this.id = id;
            this.startTimeNanos = PingTracker.this.ticker.read();
        }

        private synchronized void fail(Status status) {
            if (!this.done) {
                this.done = true;
                this.executor.execute(() -> this.callback.onFailure((Throwable)status.asException()));
            }
        }

        private synchronized void success() {
            if (!this.done) {
                this.done = true;
                this.executor.execute(() -> this.callback.onSuccess(PingTracker.this.ticker.read() - this.startTimeNanos));
            }
        }
    }

    static interface PingSender {
        public void sendPing(int var1) throws StatusException;
    }
}

