/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import androidx.annotation.RequiresApi;

public final class BindServiceFlags {
    public static final BindServiceFlags DEFAULTS = BindServiceFlags.newBuilder().setAutoCreate(true).build();
    private final int flags;

    private BindServiceFlags(int flags) {
        this.flags = flags;
    }

    public int toInteger() {
        return this.flags;
    }

    static Builder newBuilder() {
        return new Builder(0);
    }

    public Builder toBuilder() {
        return new Builder(this.flags);
    }

    public String toString() {
        return "BindServiceFlags{" + Integer.toHexString(this.flags) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindServiceFlags that = (BindServiceFlags)o;
        return this.flags == that.flags;
    }

    public int hashCode() {
        return this.flags;
    }

    public static final class Builder {
        private int flags;

        private Builder(int flags) {
            this.flags = flags;
        }

        public Builder setAboveClient(boolean newValue) {
            return this.setFlag(8, newValue);
        }

        public Builder setAdjustWithActivity(boolean newValue) {
            return this.setFlag(128, newValue);
        }

        public Builder setAllowOomManagement(boolean newValue) {
            return this.setFlag(16, newValue);
        }

        public Builder setAutoCreate(boolean newValue) {
            return this.setFlag(1, newValue);
        }

        public Builder setImportant(boolean newValue) {
            return this.setFlag(64, newValue);
        }

        @RequiresApi(api=29)
        public Builder setIncludeCapabilities(boolean newValue) {
            return this.setFlag(4096, newValue);
        }

        public Builder setNotForeground(boolean newValue) {
            return this.setFlag(4, newValue);
        }

        @RequiresApi(api=29)
        public Builder setNotPerceptible(boolean newValue) {
            return this.setFlag(256, newValue);
        }

        public Builder setWaivePriority(boolean newValue) {
            return this.setFlag(32, newValue);
        }

        public BindServiceFlags build() {
            return new BindServiceFlags(this.flags);
        }

        private Builder setFlag(int flag, boolean newValue) {
            this.flags = newValue ? (this.flags |= flag) : (this.flags &= ~flag);
            return this;
        }
    }
}

