/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import android.content.Context;
import androidx.core.content.ContextCompat;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannelBuilder;
import io.grpc.binder.AndroidComponentAddress;
import io.grpc.binder.BindServiceFlags;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.SecurityPolicies;
import io.grpc.binder.SecurityPolicy;
import io.grpc.binder.internal.BinderTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImplBuilder;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SharedResourcePool;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
public final class BinderChannelBuilder
extends ForwardingChannelBuilder<BinderChannelBuilder> {
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private Executor mainThreadExecutor;
    private ObjectPool<ScheduledExecutorService> schedulerPool = SharedResourcePool.forResource((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
    private SecurityPolicy securityPolicy;
    private InboundParcelablePolicy inboundParcelablePolicy;
    private BindServiceFlags bindServiceFlags;

    public static BinderChannelBuilder forAddress(AndroidComponentAddress directAddress, Context sourceContext) {
        return new BinderChannelBuilder((AndroidComponentAddress)Preconditions.checkNotNull((Object)directAddress, (Object)"directAddress"), null, sourceContext);
    }

    public static BinderChannelBuilder forTarget(String target, Context sourceContext) {
        return new BinderChannelBuilder(null, (String)Preconditions.checkNotNull((Object)target, (Object)"target"), sourceContext);
    }

    @DoNotCall(value="Unsupported. Use forAddress(AndroidComponentAddress, Context) instead")
    public static BinderChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forAddress(AndroidComponentAddress, Context) instead");
    }

    @DoNotCall(value="Unsupported. Use forTarget(String, Context) instead")
    public static BinderChannelBuilder forTarget(String target) {
        throw new UnsupportedOperationException("call forAddress(AndroidComponentAddress, Context) instead");
    }

    private BinderChannelBuilder(@Nullable AndroidComponentAddress directAddress, @Nullable String target, final Context sourceContext) {
        this.mainThreadExecutor = ContextCompat.getMainExecutor((Context)((Context)Preconditions.checkNotNull((Object)sourceContext, (Object)"sourceContext")));
        this.securityPolicy = SecurityPolicies.internalOnly();
        this.inboundParcelablePolicy = InboundParcelablePolicy.DEFAULT;
        this.bindServiceFlags = BindServiceFlags.DEFAULTS;
        final class BinderChannelTransportFactoryBuilder
        implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
            BinderChannelTransportFactoryBuilder() {
            }

            public ClientTransportFactory buildClientTransportFactory() {
                return new TransportFactory(sourceContext, BinderChannelBuilder.this.mainThreadExecutor, (ObjectPool<ScheduledExecutorService>)BinderChannelBuilder.this.schedulerPool, (ObjectPool<? extends Executor>)BinderChannelBuilder.this.managedChannelImplBuilder.getOffloadExecutorPool(), BinderChannelBuilder.this.securityPolicy, BinderChannelBuilder.this.bindServiceFlags, BinderChannelBuilder.this.inboundParcelablePolicy);
            }
        }
        this.managedChannelImplBuilder = directAddress != null ? new ManagedChannelImplBuilder((SocketAddress)directAddress, directAddress.getAuthority(), (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new BinderChannelTransportFactoryBuilder(), null) : new ManagedChannelImplBuilder(target, (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new BinderChannelTransportFactoryBuilder(), null);
    }

    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    public BinderChannelBuilder setBindServiceFlags(BindServiceFlags bindServiceFlags) {
        this.bindServiceFlags = bindServiceFlags;
        return this;
    }

    public BinderChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.schedulerPool = new FixedObjectPool((Object)((ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService")));
        return this;
    }

    public BinderChannelBuilder mainThreadExecutor(Executor mainThreadExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
        return this;
    }

    public BinderChannelBuilder securityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = (SecurityPolicy)Preconditions.checkNotNull((Object)securityPolicy, (Object)"securityPolicy");
        return this;
    }

    public BinderChannelBuilder inboundParcelablePolicy(InboundParcelablePolicy inboundParcelablePolicy) {
        this.inboundParcelablePolicy = (InboundParcelablePolicy)Preconditions.checkNotNull((Object)inboundParcelablePolicy, (Object)"inboundParcelablePolicy");
        return this;
    }

    private static final class TransportFactory
    implements ClientTransportFactory {
        private final Context sourceContext;
        private final Executor mainThreadExecutor;
        private final ObjectPool<ScheduledExecutorService> scheduledExecutorPool;
        private final ObjectPool<? extends Executor> offloadExecutorPool;
        private final SecurityPolicy securityPolicy;
        private final InboundParcelablePolicy inboundParcelablePolicy;
        private final BindServiceFlags bindServiceFlags;
        private ScheduledExecutorService executorService;
        private Executor offloadExecutor;
        private boolean closed;

        TransportFactory(Context sourceContext, Executor mainThreadExecutor, ObjectPool<ScheduledExecutorService> scheduledExecutorPool, ObjectPool<? extends Executor> offloadExecutorPool, SecurityPolicy securityPolicy, BindServiceFlags bindServiceFlags, InboundParcelablePolicy inboundParcelablePolicy) {
            this.sourceContext = sourceContext;
            this.mainThreadExecutor = mainThreadExecutor;
            this.scheduledExecutorPool = scheduledExecutorPool;
            this.offloadExecutorPool = offloadExecutorPool;
            this.securityPolicy = securityPolicy;
            this.bindServiceFlags = bindServiceFlags;
            this.inboundParcelablePolicy = inboundParcelablePolicy;
            this.executorService = (ScheduledExecutorService)scheduledExecutorPool.getObject();
            this.offloadExecutor = (Executor)offloadExecutorPool.getObject();
        }

        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new BinderTransport.BinderClientTransport(this.sourceContext, (AndroidComponentAddress)addr, this.bindServiceFlags, this.mainThreadExecutor, this.scheduledExecutorPool, this.offloadExecutorPool, this.securityPolicy, this.inboundParcelablePolicy, options.getEagAttributes());
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.executorService;
        }

        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            return null;
        }

        public void close() {
            this.closed = true;
            this.executorService = (ScheduledExecutorService)this.scheduledExecutorPool.returnObject((Object)this.executorService);
            this.offloadExecutor = (Executor)this.offloadExecutorPool.returnObject((Object)this.offloadExecutor);
        }
    }
}

