/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.binder.AndroidComponentAddress;
import io.grpc.binder.IBinderReceiver;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.SecurityPolicies;
import io.grpc.binder.ServerSecurityPolicy;
import io.grpc.binder.internal.BinderServer;
import io.grpc.binder.internal.BinderTransportSecurity;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SharedResourcePool;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
public final class BinderServerBuilder
extends ForwardingServerBuilder<BinderServerBuilder> {
    private final ServerImplBuilder serverImplBuilder;
    private ObjectPool<ScheduledExecutorService> schedulerPool = SharedResourcePool.forResource((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
    private ServerSecurityPolicy securityPolicy = SecurityPolicies.serverInternalOnly();
    private InboundParcelablePolicy inboundParcelablePolicy = InboundParcelablePolicy.DEFAULT;

    public static BinderServerBuilder forAddress(AndroidComponentAddress listenAddress, IBinderReceiver receiver) {
        return new BinderServerBuilder(listenAddress, receiver);
    }

    @DoNotCall(value="Unsupported. Use forAddress() instead")
    public static BinderServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("call forAddress() instead");
    }

    private BinderServerBuilder(AndroidComponentAddress listenAddress, IBinderReceiver binderReceiver) {
        this.serverImplBuilder = new ServerImplBuilder(streamTracerFactories -> {
            BinderServer server = new BinderServer(listenAddress, this.schedulerPool, streamTracerFactories, this.securityPolicy, this.inboundParcelablePolicy);
            binderReceiver.set(server.getHostBinder());
            return server;
        });
        this.decompressorRegistry(DecompressorRegistry.emptyInstance());
        this.compressorRegistry(CompressorRegistry.newEmptyInstance());
        this.serverImplBuilder.setStatsEnabled(false);
        this.serverImplBuilder.setTracingEnabled(false);
        BinderTransportSecurity.installAuthInterceptor(this);
    }

    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public BinderServerBuilder enableStats() {
        this.serverImplBuilder.setStatsEnabled(true);
        return this;
    }

    public BinderServerBuilder enableTracing() {
        this.serverImplBuilder.setTracingEnabled(true);
        return this;
    }

    public BinderServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.schedulerPool = new FixedObjectPool((Object)((ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService")));
        return this;
    }

    public BinderServerBuilder securityPolicy(ServerSecurityPolicy securityPolicy) {
        this.securityPolicy = (ServerSecurityPolicy)Preconditions.checkNotNull((Object)securityPolicy, (Object)"securityPolicy");
        return this;
    }

    public BinderServerBuilder inboundParcelablePolicy(InboundParcelablePolicy inboundParcelablePolicy) {
        this.inboundParcelablePolicy = (InboundParcelablePolicy)Preconditions.checkNotNull((Object)inboundParcelablePolicy, (Object)"inboundParcelablePolicy");
        return this;
    }

    public BinderServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in BinderServer");
    }

    public Server build() {
        return super.build();
    }
}

