/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.grpc.ManagedChannel;
import io.grpc.Server;

public final class LifecycleOnDestroyHelper {
    private LifecycleOnDestroyHelper() {
    }

    @MainThread
    public static void shutdownUponDestruction(Lifecycle lifecycle, final ManagedChannel channel) {
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            channel.shutdownNow();
        } else {
            lifecycle.addObserver((LifecycleObserver)new LifecycleEventObserver(){

                public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY) {
                        source.getLifecycle().removeObserver((LifecycleObserver)this);
                        channel.shutdownNow();
                    }
                }
            });
        }
    }

    @MainThread
    public static void shutdownUponDestruction(Lifecycle lifecycle, final Server server) {
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            server.shutdownNow();
        } else {
            lifecycle.addObserver((LifecycleObserver)new LifecycleEventObserver(){

                public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY) {
                        source.getLifecycle().removeObserver((LifecycleObserver)this);
                        server.shutdownNow();
                    }
                }
            });
        }
    }
}

