/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import com.google.common.collect.ImmutableMap;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.binder.SecurityPolicies;
import io.grpc.binder.SecurityPolicy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
public final class ServerSecurityPolicy {
    private final SecurityPolicy defaultPolicy = SecurityPolicies.internalOnly();
    private final ImmutableMap<String, SecurityPolicy> perServicePolicies;

    ServerSecurityPolicy() {
        this((ImmutableMap<String, SecurityPolicy>)ImmutableMap.of());
    }

    private ServerSecurityPolicy(ImmutableMap<String, SecurityPolicy> perServicePolicies) {
        this.perServicePolicies = perServicePolicies;
    }

    @CheckReturnValue
    public Status checkAuthorizationForService(int uid, String serviceName) {
        return ((SecurityPolicy)this.perServicePolicies.getOrDefault((Object)serviceName, (Object)this.defaultPolicy)).checkAuthorization(uid);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, SecurityPolicy> grpcServicePolicies = new HashMap<String, SecurityPolicy>();

        private Builder() {
        }

        public Builder servicePolicy(String serviceName, SecurityPolicy policy) {
            this.grpcServicePolicies.put(serviceName, policy);
            return this;
        }

        public ServerSecurityPolicy build() {
            return new ServerSecurityPolicy(ImmutableMap.copyOf(this.grpcServicePolicies));
        }
    }
}

