/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import io.grpc.Attributes;
import io.grpc.Internal;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.binder.ServerSecurityPolicy;
import io.grpc.internal.GrpcAttributes;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;

public final class BinderTransportSecurity {
    private static final Attributes.Key<TransportAuthorizationState> TRANSPORT_AUTHORIZATION_STATE = Attributes.Key.create((String)"internal:transport-authorization-state");

    private BinderTransportSecurity() {
    }

    @Internal
    public static void installAuthInterceptor(ServerBuilder<?> serverBuilder) {
        serverBuilder.intercept((ServerInterceptor)new ServerAuthInterceptor());
    }

    @Internal
    public static void attachAuthAttrs(Attributes.Builder builder, int remoteUid, ServerSecurityPolicy securityPolicy) {
        builder.set(TRANSPORT_AUTHORIZATION_STATE, (Object)new TransportAuthorizationState(remoteUid, securityPolicy)).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY);
    }

    private static final class TransportAuthorizationState {
        private final int uid;
        private final ServerSecurityPolicy policy;
        private final ConcurrentHashMap<String, Status> serviceAuthorization;

        TransportAuthorizationState(int uid, ServerSecurityPolicy policy) {
            this.uid = uid;
            this.policy = policy;
            this.serviceAuthorization = new ConcurrentHashMap(8);
        }

        @CheckReturnValue
        Status checkAuthorization(MethodDescriptor<?, ?> method) {
            Status authorization;
            String serviceName = method.getServiceName();
            boolean useCache = method.isSampledToLocalTracing();
            if (useCache && (authorization = this.serviceAuthorization.get(serviceName)) != null) {
                return authorization;
            }
            authorization = this.policy.checkAuthorizationForService(this.uid, serviceName);
            if (useCache) {
                this.serviceAuthorization.putIfAbsent(serviceName, authorization);
            }
            return authorization;
        }
    }

    private static final class ServerAuthInterceptor
    implements ServerInterceptor {
        private ServerAuthInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            Status authStatus = ((TransportAuthorizationState)call.getAttributes().get(TRANSPORT_AUTHORIZATION_STATE)).checkAuthorization(call.getMethodDescriptor());
            if (authStatus.isOk()) {
                return next.startCall(call, headers);
            }
            call.close(authStatus, new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
    }
}

