/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

final class BlockPool {
    private static final int BLOCK_SIZE = Math.max(16384, 8192);
    private static final int BLOCK_POOL_SIZE = 131072 / BLOCK_SIZE;
    private static final Queue<byte[]> blockPool = new LinkedBlockingQueue<byte[]>(BLOCK_POOL_SIZE);

    private BlockPool() {
    }

    static byte[] acquireBlock() {
        return BlockPool.acquireBlock(BLOCK_SIZE);
    }

    static byte[] acquireBlock(int size) {
        byte[] block;
        if (size == BLOCK_SIZE && (block = blockPool.poll()) != null) {
            return block;
        }
        return new byte[size];
    }

    static void releaseBlock(byte[] block) {
        if (block.length == BLOCK_SIZE) {
            blockPool.offer(block);
        }
    }
}

