/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Parcel;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.internal.BinderTransport;
import io.grpc.binder.internal.BlockInputStream;
import io.grpc.binder.internal.BlockPool;
import io.grpc.binder.internal.MetadataHelper;
import io.grpc.binder.internal.MultiMessageServerStream;
import io.grpc.binder.internal.Outbound;
import io.grpc.binder.internal.ParcelableInputStream;
import io.grpc.binder.internal.SingleMessageServerStream;
import io.grpc.binder.internal.TransactionUtils;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.StreamListener;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class Inbound<L extends StreamListener>
implements StreamListener.MessageProducer {
    protected final BinderTransport transport;
    protected final Attributes attributes;
    final int callId;
    @Nullable
    @GuardedBy(value="this")
    protected Outbound outbound;
    @Nullable
    @GuardedBy(value="this")
    protected StatsTraceContext statsTraceContext;
    @Nullable
    @GuardedBy(value="this")
    protected L listener;
    @Nullable
    @GuardedBy(value="this")
    private InputStream firstMessage;
    @GuardedBy(value="this")
    private int firstQueuedTransactionIndex;
    @GuardedBy(value="this")
    private int nextCompleteMessageEnd;
    @Nullable
    @GuardedBy(value="this")
    private ArrayList<TransactionData> queuedTransactionData;
    @GuardedBy(value="this")
    private boolean suffixAvailable;
    @GuardedBy(value="this")
    private int suffixTransactionIndex;
    @GuardedBy(value="this")
    private int inboundDataSize;
    @GuardedBy(value="this")
    private State deliveryState = State.UNINITIALIZED;
    @GuardedBy(value="this")
    private int numReceivedMessages;
    @GuardedBy(value="this")
    private int numRequestedMessages;
    @GuardedBy(value="this")
    private boolean delivering;
    @GuardedBy(value="this")
    private boolean producingMessages;

    private Inbound(BinderTransport transport, Attributes attributes, int callId) {
        this.transport = transport;
        this.attributes = attributes;
        this.callId = callId;
    }

    @GuardedBy(value="this")
    final void init(Outbound outbound, L listener) {
        this.outbound = outbound;
        this.statsTraceContext = outbound.getStatsTraceContext();
        this.listener = listener;
        if (!this.isClosed()) {
            this.onDeliveryState(State.INITIALIZED);
        }
    }

    final void unregister() {
        this.transport.unregisterInbound(this);
    }

    boolean countsForInUse() {
        return false;
    }

    @GuardedBy(value="this")
    protected final void onDeliveryState(State deliveryState) {
        Inbound.checkTransition(this.deliveryState, deliveryState);
        this.deliveryState = deliveryState;
    }

    @GuardedBy(value="this")
    protected final boolean isClosed() {
        return this.deliveryState == State.CLOSED;
    }

    @GuardedBy(value="this")
    private final boolean messageAvailable() {
        return this.firstMessage != null || this.nextCompleteMessageEnd > 0;
    }

    @GuardedBy(value="this")
    private boolean receivedAllTransactions() {
        return this.suffixAvailable && this.firstQueuedTransactionIndex >= this.suffixTransactionIndex;
    }

    @GuardedBy(value="this")
    final void deliver() {
        if (this.delivering) {
            return;
        }
        this.delivering = true;
        while (this.canDeliver()) {
            this.deliverInternal();
        }
        this.delivering = false;
    }

    @GuardedBy(value="this")
    private final boolean canDeliver() {
        switch (this.deliveryState) {
            case PREFIX_DELIVERED: {
                if (this.listener != null) {
                    if (this.producingMessages) {
                        return false;
                    }
                    if (this.messageAvailable()) {
                        return this.numRequestedMessages != 0;
                    }
                    return this.receivedAllTransactions();
                }
                return false;
            }
            case ALL_MESSAGES_DELIVERED: {
                return this.listener != null && this.suffixAvailable;
            }
        }
        return false;
    }

    @GuardedBy(value="this")
    private final void deliverInternal() {
        switch (this.deliveryState) {
            case PREFIX_DELIVERED: {
                if (this.producingMessages) break;
                if (this.messageAvailable()) {
                    this.producingMessages = true;
                    this.listener.messagesAvailable((StreamListener.MessageProducer)this);
                    break;
                }
                if (!this.suffixAvailable) break;
                this.onDeliveryState(State.ALL_MESSAGES_DELIVERED);
            }
            case ALL_MESSAGES_DELIVERED: {
                if (!this.suffixAvailable) break;
                this.onDeliveryState(State.SUFFIX_DELIVERED);
                this.deliverSuffix();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected abstract void deliverSuffix();

    @GuardedBy(value="this")
    final void closeOnCancel(Status status) {
        this.closeAbnormal(Status.CANCELLED, status, false);
    }

    @GuardedBy(value="this")
    private final void closeOutOfBand(Status status) {
        this.closeAbnormal(status, status, true);
    }

    @GuardedBy(value="this")
    final void closeAbnormal(Status status) {
        this.closeAbnormal(status, status, false);
    }

    @GuardedBy(value="this")
    private final void closeAbnormal(Status outboundStatus, Status internalStatus, boolean isOobFromRemote) {
        if (!this.isClosed()) {
            boolean wasInitialized = this.deliveryState != State.UNINITIALIZED;
            this.onDeliveryState(State.CLOSED);
            if (wasInitialized) {
                this.statsTraceContext.streamClosed(internalStatus);
            }
            if (!isOobFromRemote) {
                this.transport.sendOutOfBandClose(this.callId, outboundStatus);
            }
            if (wasInitialized) {
                this.deliverCloseAbnormal(internalStatus);
            }
            this.unregister();
        }
    }

    @GuardedBy(value="this")
    protected abstract void deliverCloseAbnormal(Status var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTransportReady() {
        Outbound outbound = null;
        Object listener = null;
        Object object = this;
        synchronized (object) {
            outbound = this.outbound;
            listener = this.listener;
        }
        if (listener != null) {
            listener.onReady();
        }
        if (outbound != null) {
            try {
                object = outbound;
                synchronized (object) {
                    outbound.onTransportReady();
                }
            }
            catch (StatusException se) {
                Inbound inbound = this;
                synchronized (inbound) {
                    this.closeAbnormal(se.getStatus());
                }
            }
        }
    }

    @GuardedBy(value="this")
    public void requestMessages(int num) {
        this.numRequestedMessages += num;
        this.deliver();
    }

    final synchronized void handleTransaction(Parcel parcel) {
        if (this.isClosed()) {
            return;
        }
        try {
            int flags = parcel.readInt();
            if (TransactionUtils.hasFlag(flags, 8)) {
                this.closeOutOfBand(TransactionUtils.readStatus(flags, parcel));
                return;
            }
            int index = parcel.readInt();
            boolean hasPrefix = TransactionUtils.hasFlag(flags, 1);
            boolean hasMessageData = TransactionUtils.hasFlag(flags, 2);
            boolean hasSuffix = TransactionUtils.hasFlag(flags, 4);
            if (hasPrefix) {
                this.handlePrefix(flags, parcel);
                this.onDeliveryState(State.PREFIX_DELIVERED);
            }
            if (hasMessageData) {
                this.handleMessageData(flags, index, parcel);
            }
            if (hasSuffix) {
                this.handleSuffix(flags, parcel);
                this.suffixTransactionIndex = index;
                this.suffixAvailable = true;
            }
            if (index == this.firstQueuedTransactionIndex) {
                if (this.queuedTransactionData == null) {
                    ++this.firstQueuedTransactionIndex;
                } else if (!hasMessageData && !hasSuffix) {
                    this.queuedTransactionData.remove(0);
                    ++this.firstQueuedTransactionIndex;
                }
            }
            this.reportInboundSize(parcel.dataSize());
            this.deliver();
        }
        catch (StatusException se) {
            this.closeAbnormal(se.getStatus());
        }
    }

    @GuardedBy(value="this")
    abstract void handlePrefix(int var1, Parcel var2) throws StatusException;

    @GuardedBy(value="this")
    abstract void handleSuffix(int var1, Parcel var2) throws StatusException;

    @GuardedBy(value="this")
    private void handleMessageData(int flags, int index, Parcel parcel) throws StatusException {
        ParcelableInputStream stream = null;
        byte[] block = null;
        boolean lastBlockOfMessage = true;
        int numBytes = 0;
        if ((flags & 0x40) != 0) {
            InboundParcelablePolicy policy = (InboundParcelablePolicy)this.attributes.get(BinderTransport.INBOUND_PARCELABLE_POLICY);
            if (policy == null || !policy.shouldAcceptParcelableMessages()) {
                throw Status.PERMISSION_DENIED.withDescription("Parcelable messages not allowed").asException();
            }
            int startPos = parcel.dataPosition();
            stream = ParcelableInputStream.readFromParcel(parcel, this.getClass().getClassLoader());
            numBytes = parcel.dataPosition() - startPos;
        } else {
            numBytes = parcel.readInt();
            block = BlockPool.acquireBlock(numBytes);
            if (numBytes > 0) {
                parcel.readByteArray(block);
            }
            if ((flags & 0x80) != 0) {
                lastBlockOfMessage = false;
            }
        }
        if (this.queuedTransactionData == null) {
            if (this.numReceivedMessages == 0 && lastBlockOfMessage && index == this.firstQueuedTransactionIndex) {
                Preconditions.checkState((this.firstMessage == null ? 1 : 0) != 0);
                this.firstMessage = stream != null ? stream : new BlockInputStream(block);
                this.reportInboundMessage(numBytes);
                return;
            }
            this.queuedTransactionData = new ArrayList(16);
        }
        this.enqueueTransactionData(index, new TransactionData(stream, block, numBytes, lastBlockOfMessage));
    }

    @GuardedBy(value="this")
    private void enqueueTransactionData(int index, TransactionData data) {
        int offset = index - this.firstQueuedTransactionIndex;
        if (offset < this.queuedTransactionData.size()) {
            this.queuedTransactionData.set(offset, data);
            this.lookForCompleteMessage();
        } else if (offset > this.queuedTransactionData.size()) {
            do {
                this.queuedTransactionData.add(null);
            } while (offset > this.queuedTransactionData.size());
            this.queuedTransactionData.add(data);
        } else {
            this.queuedTransactionData.add(data);
            this.lookForCompleteMessage();
        }
    }

    @GuardedBy(value="this")
    private void lookForCompleteMessage() {
        int numBytes = 0;
        if (this.nextCompleteMessageEnd == 0) {
            for (int i = 0; i < this.queuedTransactionData.size(); ++i) {
                TransactionData data = this.queuedTransactionData.get(i);
                if (data == null) {
                    return;
                }
                numBytes += data.numBytes;
                if (!data.lastBlockOfMessage) continue;
                this.nextCompleteMessageEnd = i + 1;
                this.reportInboundMessage(numBytes);
                return;
            }
        }
    }

    @Nullable
    public final synchronized InputStream next() {
        InputStream stream = null;
        if (this.firstMessage != null) {
            stream = this.firstMessage;
            this.firstMessage = null;
        } else if (this.numRequestedMessages > 0 && this.messageAvailable()) {
            stream = this.assembleNextMessage();
        }
        if (stream != null) {
            --this.numRequestedMessages;
        } else {
            this.producingMessages = false;
            if (this.receivedAllTransactions() && !this.isClosed()) {
                this.onDeliveryState(State.ALL_MESSAGES_DELIVERED);
                this.deliver();
            }
        }
        return stream;
    }

    @GuardedBy(value="this")
    private InputStream assembleNextMessage() {
        InputStream message;
        int numBlocks = this.nextCompleteMessageEnd;
        this.nextCompleteMessageEnd = 0;
        int numBytes = 0;
        if (numBlocks == 1) {
            TransactionData data = this.queuedTransactionData.remove(0);
            numBytes = data.numBytes;
            message = data.stream != null ? data.stream : new BlockInputStream(data.block);
        } else {
            byte[][] blocks = new byte[numBlocks][];
            for (int i = 0; i < numBlocks; ++i) {
                TransactionData data = this.queuedTransactionData.remove(0);
                blocks[i] = (byte[])Preconditions.checkNotNull((Object)data.block);
                numBytes += blocks[i].length;
            }
            message = new BlockInputStream(blocks, numBytes);
        }
        this.firstQueuedTransactionIndex += numBlocks;
        this.lookForCompleteMessage();
        return message;
    }

    @GuardedBy(value="this")
    private void reportInboundSize(int size) {
        this.inboundDataSize += size;
        if (this.statsTraceContext != null && this.inboundDataSize != 0) {
            this.statsTraceContext.inboundWireSize((long)this.inboundDataSize);
            this.statsTraceContext.inboundUncompressedSize((long)this.inboundDataSize);
            this.inboundDataSize = 0;
        }
    }

    @GuardedBy(value="this")
    private void reportInboundMessage(int numBytes) {
        Preconditions.checkNotNull((Object)this.statsTraceContext);
        this.statsTraceContext.inboundMessage(this.numReceivedMessages);
        this.statsTraceContext.inboundMessageRead(this.numReceivedMessages, (long)numBytes, (long)numBytes);
        ++this.numReceivedMessages;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[SfxA=" + this.suffixAvailable + "/De=" + (Object)((Object)this.deliveryState) + "/Msg=" + this.messageAvailable() + "/Lis=" + (this.listener != null) + "]";
    }

    private static void checkTransition(State current, State next) {
        switch (next) {
            case INITIALIZED: {
                Preconditions.checkState((current == State.UNINITIALIZED ? 1 : 0) != 0, (String)"%s -> %s", (Object)((Object)current), (Object)((Object)next));
                break;
            }
            case PREFIX_DELIVERED: {
                Preconditions.checkState((current == State.INITIALIZED || current == State.UNINITIALIZED ? 1 : 0) != 0, (String)"%s -> %s", (Object)((Object)current), (Object)((Object)next));
                break;
            }
            case ALL_MESSAGES_DELIVERED: {
                Preconditions.checkState((current == State.PREFIX_DELIVERED ? 1 : 0) != 0, (String)"%s -> %s", (Object)((Object)current), (Object)((Object)next));
                break;
            }
            case SUFFIX_DELIVERED: {
                Preconditions.checkState((current == State.ALL_MESSAGES_DELIVERED ? 1 : 0) != 0, (String)"%s -> %s", (Object)((Object)current), (Object)((Object)next));
                break;
            }
            case CLOSED: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static final class TransactionData {
        @Nullable
        final InputStream stream;
        @Nullable
        final byte[] block;
        final int numBytes;
        final boolean lastBlockOfMessage;

        TransactionData(InputStream stream, byte[] block, int numBytes, boolean lastBlockOfMessage) {
            this.stream = stream;
            this.block = block;
            this.numBytes = numBytes;
            this.lastBlockOfMessage = lastBlockOfMessage;
        }

        public String toString() {
            return "TransactionData[" + this.numBytes + "b " + (this.stream != null ? "stream" : "array") + (this.lastBlockOfMessage ? "(last)]" : "]");
        }
    }

    static final class ServerInbound
    extends Inbound<ServerStreamListener> {
        private final BinderTransport.BinderServerTransport serverTransport;

        ServerInbound(BinderTransport.BinderServerTransport transport, Attributes attributes, int callId) {
            super(transport, attributes, callId);
            this.serverTransport = transport;
        }

        @Override
        @GuardedBy(value="this")
        protected void handlePrefix(int flags, Parcel parcel) throws StatusException {
            String methodName = parcel.readString();
            Metadata headers = MetadataHelper.readMetadata(parcel, this.attributes);
            StatsTraceContext statsTraceContext = this.serverTransport.createStatsTraceContext(methodName, headers);
            Outbound.ServerOutbound outbound = new Outbound.ServerOutbound(this.serverTransport, this.callId, statsTraceContext);
            Object stream = (flags & 0x10) != 0 ? new SingleMessageServerStream(this, outbound, this.attributes) : new MultiMessageServerStream(this, outbound, this.attributes);
            Status status = this.serverTransport.startStream((ServerStream)stream, methodName, headers);
            if (status.isOk()) {
                Preconditions.checkNotNull((Object)((ServerStreamListener)this.listener));
                if (this.transport.isReady()) {
                    ((ServerStreamListener)this.listener).onReady();
                }
            } else {
                this.closeAbnormal(status);
            }
        }

        @Override
        @GuardedBy(value="this")
        protected void handleSuffix(int flags, Parcel parcel) {
        }

        @Override
        @GuardedBy(value="this")
        protected void deliverSuffix() {
            ((ServerStreamListener)this.listener).halfClosed();
        }

        @Override
        @GuardedBy(value="this")
        protected void deliverCloseAbnormal(Status status) {
            ((ServerStreamListener)this.listener).closed(status);
        }

        @GuardedBy(value="this")
        void onCloseSent(Status status) {
            if (!this.isClosed()) {
                this.onDeliveryState(State.CLOSED);
                this.statsTraceContext.streamClosed(status);
                ((ServerStreamListener)this.listener).closed(Status.OK);
            }
        }
    }

    static final class ClientInbound
    extends Inbound<ClientStreamListener> {
        private final boolean countsForInUse;
        @Nullable
        @GuardedBy(value="this")
        private Status closeStatus;
        @Nullable
        @GuardedBy(value="this")
        private Metadata trailers;

        ClientInbound(BinderTransport transport, Attributes attributes, int callId, boolean countsForInUse) {
            super(transport, attributes, callId);
            this.countsForInUse = countsForInUse;
        }

        @Override
        boolean countsForInUse() {
            return this.countsForInUse;
        }

        @Override
        @GuardedBy(value="this")
        protected void handlePrefix(int flags, Parcel parcel) throws StatusException {
            Metadata headers = MetadataHelper.readMetadata(parcel, this.attributes);
            this.statsTraceContext.clientInboundHeaders();
            ((ClientStreamListener)this.listener).headersRead(headers);
        }

        @Override
        @GuardedBy(value="this")
        protected void handleSuffix(int flags, Parcel parcel) throws StatusException {
            this.closeStatus = TransactionUtils.readStatus(flags, parcel);
            this.trailers = MetadataHelper.readMetadata(parcel, this.attributes);
        }

        @Override
        @GuardedBy(value="this")
        protected void deliverSuffix() {
            this.statsTraceContext.clientInboundTrailers(this.trailers);
            this.statsTraceContext.streamClosed(this.closeStatus);
            this.onDeliveryState(State.CLOSED);
            ((ClientStreamListener)this.listener).closed(this.closeStatus, ClientStreamListener.RpcProgress.PROCESSED, this.trailers);
            this.unregister();
        }

        @Override
        @GuardedBy(value="this")
        protected void deliverCloseAbnormal(Status status) {
            ((ClientStreamListener)this.listener).closed(status, ClientStreamListener.RpcProgress.PROCESSED, new Metadata());
        }
    }

    static enum State {
        UNINITIALIZED,
        INITIALIZED,
        PREFIX_DELIVERED,
        ALL_MESSAGES_DELIVERED,
        SUFFIX_DELIVERED,
        CLOSED;

    }
}

