/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Binder;
import android.os.Parcel;
import io.grpc.Internal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public final class LeakSafeOneWayBinder
extends Binder {
    private static final Logger logger = Logger.getLogger(LeakSafeOneWayBinder.class.getName());
    @Nullable
    private TransactionHandler handler;

    public LeakSafeOneWayBinder(TransactionHandler handler) {
        this.handler = handler;
    }

    public void detach() {
        this.handler = null;
    }

    protected boolean onTransact(int code, Parcel parcel, Parcel reply, int flags) {
        TransactionHandler handler = this.handler;
        if (handler != null) {
            try {
                return handler.handleTransaction(code, parcel);
            }
            catch (RuntimeException re) {
                logger.log(Level.WARNING, "failure sending transaction " + code, re);
                return false;
            }
        }
        return false;
    }

    public boolean pingBinder() {
        return this.handler != null;
    }

    @Internal
    public static interface TransactionHandler {
        public boolean handleTransaction(int var1, Parcel var2);
    }
}

