/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

final class ParcelableInputStream<P extends Parcelable>
extends InputStream {
    @Nullable
    private final Parcelable.Creator<P> creator;
    private final boolean safeToReturnValue;
    private final P value;
    @Nullable
    InputStream delegateStream;
    @Nullable
    P sharableValue;

    ParcelableInputStream(@Nullable Parcelable.Creator<P> creator, P value, boolean safeToReturnValue) {
        this.creator = creator;
        this.value = value;
        this.safeToReturnValue = safeToReturnValue;
        Preconditions.checkArgument((creator != null || safeToReturnValue ? 1 : 0) != 0);
    }

    static <P extends Parcelable> ParcelableInputStream<P> readFromParcel(Parcel parcel, ClassLoader classLoader) {
        Parcelable value = parcel.readParcelable(classLoader);
        return new ParcelableInputStream<Parcelable>(null, value, true);
    }

    static <P extends Parcelable> ParcelableInputStream<P> forInstance(P value, Parcelable.Creator<P> creator) {
        return new ParcelableInputStream<P>(creator, value, false);
    }

    static <P extends Parcelable> ParcelableInputStream<P> forImmutableInstance(P value, Parcelable.Creator<P> creator) {
        return new ParcelableInputStream<P>(creator, value, true);
    }

    private InputStream getDelegateStream() {
        if (this.delegateStream == null) {
            Parcel parcel = Parcel.obtain();
            parcel.writeParcelable(this.value, 0);
            byte[] res = parcel.marshall();
            parcel.recycle();
            this.delegateStream = new ByteArrayInputStream(res);
        }
        return this.delegateStream;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegateStream().read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getDelegateStream().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        return this.getDelegateStream().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.getDelegateStream().available();
    }

    @Override
    public void close() throws IOException {
        if (this.delegateStream != null) {
            this.delegateStream.close();
        }
    }

    @Override
    public void mark(int readLimit) {
        if (this.delegateStream != null) {
            this.delegateStream.mark(readLimit);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.delegateStream != null) {
            this.delegateStream.reset();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    int writeToParcel(Parcel parcel) {
        int startPos = parcel.dataPosition();
        parcel.writeParcelable(this.value, this.value.describeContents());
        return parcel.dataPosition() - startPos;
    }

    P getParcelable() {
        if (this.safeToReturnValue) {
            return this.value;
        }
        if (this.sharableValue == null) {
            this.sharableValue = ParcelableInputStream.marshallUnmarshall(this.value, (Parcelable.Creator)Preconditions.checkNotNull(this.creator));
        }
        return this.sharableValue;
    }

    private static <P extends Parcelable> P marshallUnmarshall(P value, Parcelable.Creator<P> creator) {
        Parcel parcel = Parcel.obtain();
        value.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        Parcelable result = (Parcelable)creator.createFromParcel(parcel);
        parcel.recycle();
        return (P)result;
    }

    public String toString() {
        return "ParcelableInputStream[V: " + this.value + "]";
    }
}

