/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import io.grpc.Attributes;
import io.grpc.Compressor;
import io.grpc.Deadline;
import io.grpc.DecompressorRegistry;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.internal.Inbound;
import io.grpc.binder.internal.Outbound;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.InsightBuilder;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class SingleMessageClientStream
implements ClientStream {
    private final Inbound.ClientInbound inbound;
    private final Outbound.ClientOutbound outbound;
    private final Attributes attributes;
    @Nullable
    private InputStream pendingSingleMessage;
    @Nullable
    private Deadline pendingDeadline;

    SingleMessageClientStream(Inbound.ClientInbound inbound, Outbound.ClientOutbound outbound, Attributes attributes) {
        this.inbound = inbound;
        this.outbound = outbound;
        this.attributes = attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientStreamListener listener) {
        Inbound.ClientInbound clientInbound = this.inbound;
        synchronized (clientInbound) {
            this.inbound.init(this.outbound, listener);
        }
        if (this.outbound.isReady()) {
            listener.onReady();
        }
    }

    public boolean isReady() {
        return this.outbound.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(int numMessages) {
        Inbound.ClientInbound clientInbound = this.inbound;
        synchronized (clientInbound) {
            this.inbound.requestMessages(numMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(InputStream message) {
        if (this.pendingSingleMessage != null) {
            Inbound.ClientInbound clientInbound = this.inbound;
            synchronized (clientInbound) {
                this.inbound.closeAbnormal(Status.INTERNAL.withDescription("too many messages"));
            }
        } else {
            this.pendingSingleMessage = message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halfClose() {
        try {
            Outbound.ClientOutbound clientOutbound = this.outbound;
            synchronized (clientOutbound) {
                if (this.pendingDeadline != null) {
                    this.outbound.setDeadline(this.pendingDeadline);
                }
                this.outbound.onPrefixReady();
                this.outbound.sendSingleMessageAndHalfClose(this.pendingSingleMessage);
            }
        }
        catch (StatusException se) {
            Inbound.ClientInbound clientInbound = this.inbound;
            synchronized (clientInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Status status) {
        Inbound.ClientInbound clientInbound = this.inbound;
        synchronized (clientInbound) {
            this.inbound.closeOnCancel(status);
        }
    }

    public void setDeadline(@Nonnull Deadline deadline) {
        this.pendingDeadline = deadline;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public final String toString() {
        return "SingleMessageClientStream[" + this.inbound + "/" + this.outbound + "]";
    }

    public final void flush() {
    }

    public final void setCompressor(Compressor compressor) {
    }

    public final void setMessageCompression(boolean enable) {
    }

    public void setAuthority(String authority) {
    }

    public void setMaxInboundMessageSize(int maxSize) {
    }

    public void setMaxOutboundMessageSize(int maxSize) {
    }

    public void appendTimeoutInsight(InsightBuilder insight) {
    }

    public void setFullStreamDecompression(boolean fullStreamDecompression) {
    }

    public void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
    }

    public void optimizeForDirectExecutor() {
    }
}

