/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.google.common.base.Preconditions;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public final class AndroidComponentAddress
extends SocketAddress {
    private static final long serialVersionUID = 0L;
    private final Intent bindIntent;

    protected AndroidComponentAddress(Intent bindIntent) {
        Preconditions.checkArgument((bindIntent.getComponent() != null || bindIntent.getPackage() != null ? 1 : 0) != 0, (Object)"'bindIntent' must be explicit. Specify either a package or ComponentName.");
        this.bindIntent = bindIntent;
    }

    public static AndroidComponentAddress forContext(Context context) {
        return AndroidComponentAddress.forLocalComponent(context, context.getClass());
    }

    public static AndroidComponentAddress forLocalComponent(Context context, Class<?> cls) {
        return AndroidComponentAddress.forComponent(new ComponentName(context, cls));
    }

    public static AndroidComponentAddress forRemoteComponent(String applicationPackage, String serviceClassName) {
        return AndroidComponentAddress.forComponent(new ComponentName(applicationPackage, serviceClassName));
    }

    public static AndroidComponentAddress forBindIntent(Intent intent) {
        return new AndroidComponentAddress(intent.cloneFilter());
    }

    public static AndroidComponentAddress forComponent(ComponentName component) {
        return new AndroidComponentAddress(new Intent("grpc.io.action.BIND").setComponent(component));
    }

    public String getAuthority() {
        return this.getPackage();
    }

    public String getPackage() {
        if (this.bindIntent.getPackage() != null) {
            return this.bindIntent.getPackage();
        }
        return this.bindIntent.getComponent().getPackageName();
    }

    @Nullable
    public ComponentName getComponent() {
        return this.bindIntent.getComponent();
    }

    public Intent asBindIntent() {
        return this.bindIntent.cloneFilter();
    }

    public String asAndroidAppUri() {
        Intent intentForUri = this.bindIntent;
        if (intentForUri.getPackage() == null) {
            intentForUri = intentForUri.cloneFilter().setPackage(this.getComponent().getPackageName());
        }
        return intentForUri.toUri(2);
    }

    public int hashCode() {
        Intent intentForHashCode = this.bindIntent;
        if (intentForHashCode.getPackage() != null) {
            intentForHashCode = intentForHashCode.cloneFilter().setPackage(null);
        }
        return intentForHashCode.filterHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AndroidComponentAddress) {
            AndroidComponentAddress that = (AndroidComponentAddress)obj;
            return this.bindIntent.filterEquals(that.bindIntent);
        }
        return false;
    }

    public String toString() {
        return "AndroidComponentAddress[" + this.bindIntent + "]";
    }
}

