/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.binder.AndroidComponentAddress;
import io.grpc.binder.BinderInternal;
import io.grpc.binder.IBinderReceiver;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.SecurityPolicies;
import io.grpc.binder.ServerSecurityPolicy;
import io.grpc.binder.internal.BinderServer;
import io.grpc.binder.internal.BinderTransportSecurity;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SharedResourcePool;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public final class BinderServerBuilder
extends ForwardingServerBuilder<BinderServerBuilder> {
    private final ServerImplBuilder serverImplBuilder;
    private ObjectPool<ScheduledExecutorService> schedulerPool = SharedResourcePool.forResource((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
    private ServerSecurityPolicy securityPolicy = SecurityPolicies.serverInternalOnly();
    private InboundParcelablePolicy inboundParcelablePolicy = InboundParcelablePolicy.DEFAULT;
    private boolean isBuilt;
    @Nullable
    private BinderTransportSecurity.ShutdownListener shutdownListener = null;

    public static BinderServerBuilder forAddress(AndroidComponentAddress listenAddress, IBinderReceiver receiver) {
        return new BinderServerBuilder(listenAddress, receiver);
    }

    @DoNotCall(value="Unsupported. Use forAddress() instead")
    public static BinderServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("call forAddress() instead");
    }

    private BinderServerBuilder(AndroidComponentAddress listenAddress, IBinderReceiver binderReceiver) {
        this.serverImplBuilder = new ServerImplBuilder(streamTracerFactories -> {
            BinderServer server = new BinderServer(listenAddress, this.schedulerPool, streamTracerFactories, BinderInternal.createPolicyChecker(this.securityPolicy), this.inboundParcelablePolicy, (BinderTransportSecurity.ShutdownListener)Preconditions.checkNotNull((Object)this.shutdownListener));
            BinderInternal.setIBinder(binderReceiver, server.getHostBinder());
            return server;
        });
        this.serverImplBuilder.setStatsEnabled(false);
        this.serverImplBuilder.setTracingEnabled(false);
    }

    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
    public BinderServerBuilder enableStats() {
        this.serverImplBuilder.setStatsEnabled(true);
        return this;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
    public BinderServerBuilder enableTracing() {
        this.serverImplBuilder.setTracingEnabled(true);
        return this;
    }

    public BinderServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.schedulerPool = new FixedObjectPool((Object)((ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService")));
        return this;
    }

    public BinderServerBuilder securityPolicy(ServerSecurityPolicy securityPolicy) {
        this.securityPolicy = (ServerSecurityPolicy)Preconditions.checkNotNull((Object)securityPolicy, (Object)"securityPolicy");
        return this;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
    public BinderServerBuilder inboundParcelablePolicy(InboundParcelablePolicy inboundParcelablePolicy) {
        this.inboundParcelablePolicy = (InboundParcelablePolicy)Preconditions.checkNotNull((Object)inboundParcelablePolicy, (Object)"inboundParcelablePolicy");
        return this;
    }

    public BinderServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in BinderServer");
    }

    public Server build() {
        Preconditions.checkState((!this.isBuilt ? 1 : 0) != 0, (Object)"BinderServerBuilder can only be used to build one server instance.");
        this.isBuilt = true;
        ObjectPool executorPool = this.serverImplBuilder.getExecutorPool();
        Executor executor = (Executor)executorPool.getObject();
        BinderTransportSecurity.installAuthInterceptor(this, executor);
        this.shutdownListener = () -> executorPool.returnObject((Object)executor);
        return super.build();
    }
}

