/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
public final class InboundParcelablePolicy {
    public static final int MAX_PARCELABLE_METADATA_SIZE = 32768;
    public static final InboundParcelablePolicy DEFAULT = new InboundParcelablePolicy(false, false, 32768);
    private final boolean acceptParcelableMetadataValues;
    private final boolean acceptParcelableMessages;
    private final int maxParcelableMetadataSize;

    private InboundParcelablePolicy(boolean acceptParcelableMetadataValues, boolean acceptParcelableMessages, int maxParcelableMetadataSize) {
        this.acceptParcelableMetadataValues = acceptParcelableMetadataValues;
        this.acceptParcelableMessages = acceptParcelableMessages;
        this.maxParcelableMetadataSize = maxParcelableMetadataSize;
    }

    public boolean shouldAcceptParcelableMetadataValues() {
        return this.acceptParcelableMetadataValues;
    }

    public boolean shouldAcceptParcelableMessages() {
        return this.acceptParcelableMessages;
    }

    public int getMaxParcelableMetadataSize() {
        return this.maxParcelableMetadataSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ boolean access$000(InboundParcelablePolicy x0) {
        return x0.acceptParcelableMetadataValues;
    }

    static /* synthetic */ boolean access$100(InboundParcelablePolicy x0) {
        return x0.acceptParcelableMessages;
    }

    static /* synthetic */ int access$200(InboundParcelablePolicy x0) {
        return x0.maxParcelableMetadataSize;
    }

    public static final class Builder {
        private boolean acceptParcelableMetadataValues = InboundParcelablePolicy.access$000(DEFAULT);
        private boolean acceptParcelableMessages = InboundParcelablePolicy.access$100(DEFAULT);
        private int maxParcelableMetadataSize = InboundParcelablePolicy.access$200(DEFAULT);

        public Builder setAcceptParcelableMetadataValues(boolean acceptParcelableMetadataValues) {
            this.acceptParcelableMetadataValues = acceptParcelableMetadataValues;
            return this;
        }

        public Builder setAcceptParcelableMessages(boolean acceptParcelableMessages) {
            this.acceptParcelableMessages = acceptParcelableMessages;
            return this;
        }

        public Builder setMaxParcelableMetadataSize(int maxParcelableMetadataSize) {
            Preconditions.checkArgument((maxParcelableMetadataSize <= 32768 ? 1 : 0) != 0, (Object)"Parcelable metadata size can't exceed MAX_PARCELABLE_METADATA_SIZE.");
            this.maxParcelableMetadataSize = maxParcelableMetadataSize;
            return this;
        }

        public InboundParcelablePolicy build() {
            return new InboundParcelablePolicy(this.acceptParcelableMetadataValues, this.acceptParcelableMessages, this.maxParcelableMetadataSize);
        }
    }
}

