/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import android.os.Process;
import io.grpc.ExperimentalApi;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
public final class PeerUid {
    private final int uid;

    PeerUid(int uid) {
        this.uid = uid;
    }

    public static PeerUid forCurrentProcess() {
        return new PeerUid(Process.myUid());
    }

    int getUid() {
        return this.uid;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null || this.getClass() != otherObj.getClass()) {
            return false;
        }
        PeerUid otherPeerUid = (PeerUid)otherObj;
        return this.uid == otherPeerUid.uid;
    }

    public int hashCode() {
        return Integer.valueOf(this.uid).hashCode();
    }

    public String toString() {
        return "PeerUid{" + this.uid + '}';
    }
}

