/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import android.content.pm.PackageManager;
import android.os.UserHandle;
import androidx.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ExperimentalApi;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.binder.PeerUid;
import io.grpc.binder.internal.BinderTransport;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8022")
public final class PeerUids {
    public static final Context.Key<PeerUid> REMOTE_PEER = Context.key((String)"remote-peer");

    public static String[] getInsecurePackagesForUid(PackageManager packageManager, PeerUid who) {
        return packageManager.getPackagesForUid(who.getUid());
    }

    @Nullable
    public static String getNameForUid(PackageManager packageManager, PeerUid who) {
        return packageManager.getNameForUid(who.getUid());
    }

    @RequiresApi(api=24)
    public static UserHandle getUserHandleForUid(PeerUid who) {
        return UserHandle.getUserHandleForUid((int)who.getUid());
    }

    public static ServerInterceptor newPeerIdentifyingServerInterceptor() {
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                Context context = Context.current();
                PeerUid client = new PeerUid((Integer)Preconditions.checkNotNull((Object)((Integer)call.getAttributes().get(BinderTransport.REMOTE_UID)), (Object)"Expected BinderTransport attribute REMOTE_UID was missing. Is this interceptor installed on an unsupported type of Server?"));
                return Contexts.interceptCall((Context)context.withValue(REMOTE_PEER, (Object)client), call, (Metadata)headers, next);
            }
        };
    }

    private PeerUids() {
    }
}

