/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Status;
import io.grpc.binder.AsyncSecurityPolicy;
import io.grpc.binder.SecurityPolicies;
import io.grpc.binder.SecurityPolicy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public final class ServerSecurityPolicy {
    private final SecurityPolicy defaultPolicy = SecurityPolicies.internalOnly();
    private final ImmutableMap<String, SecurityPolicy> perServicePolicies;

    ServerSecurityPolicy() {
        this((ImmutableMap<String, SecurityPolicy>)ImmutableMap.of());
    }

    private ServerSecurityPolicy(ImmutableMap<String, SecurityPolicy> perServicePolicies) {
        this.perServicePolicies = perServicePolicies;
    }

    @CheckReturnValue
    @Deprecated
    public Status checkAuthorizationForService(int uid, String serviceName) {
        return ((SecurityPolicy)this.perServicePolicies.getOrDefault((Object)serviceName, (Object)this.defaultPolicy)).checkAuthorization(uid);
    }

    @CheckReturnValue
    ListenableFuture<Status> checkAuthorizationForServiceAsync(int uid, String serviceName) {
        SecurityPolicy securityPolicy = (SecurityPolicy)this.perServicePolicies.getOrDefault((Object)serviceName, (Object)this.defaultPolicy);
        if (securityPolicy instanceof AsyncSecurityPolicy) {
            return ((AsyncSecurityPolicy)securityPolicy).checkAuthorizationAsync(uid);
        }
        try {
            Status status = securityPolicy.checkAuthorization(uid);
            return Futures.immediateFuture((Object)status);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, SecurityPolicy> grpcServicePolicies = new HashMap<String, SecurityPolicy>();

        private Builder() {
        }

        public Builder servicePolicy(String serviceName, SecurityPolicy policy) {
            this.grpcServicePolicies.put(serviceName, policy);
            return this;
        }

        public ServerSecurityPolicy build() {
            return new ServerSecurityPolicy(ImmutableMap.copyOf(this.grpcServicePolicies));
        }
    }
}

