/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import android.content.Context;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.TransactionTooLargeException;
import android.os.UserHandle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.Grpc;
import io.grpc.Internal;
import io.grpc.InternalChannelz;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.AndroidComponentAddress;
import io.grpc.binder.BindServiceFlags;
import io.grpc.binder.BinderChannelCredentials;
import io.grpc.binder.InboundParcelablePolicy;
import io.grpc.binder.SecurityPolicy;
import io.grpc.binder.internal.Bindable;
import io.grpc.binder.internal.FlowController;
import io.grpc.binder.internal.Inbound;
import io.grpc.binder.internal.LeakSafeOneWayBinder;
import io.grpc.binder.internal.MultiMessageClientStream;
import io.grpc.binder.internal.OneWayBinderProxy;
import io.grpc.binder.internal.Outbound;
import io.grpc.binder.internal.ParcelHolder;
import io.grpc.binder.internal.PingTracker;
import io.grpc.binder.internal.ServiceBinding;
import io.grpc.binder.internal.SingleMessageClientStream;
import io.grpc.binder.internal.TransactionUtils;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.FailingClientStream;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class BinderTransport
implements LeakSafeOneWayBinder.TransactionHandler,
IBinder.DeathRecipient {
    private static final Logger logger = Logger.getLogger(BinderTransport.class.getName());
    @Internal
    public static final Attributes.Key<Integer> REMOTE_UID = Attributes.Key.create((String)"internal:remote-uid");
    @Internal
    public static final Attributes.Key<String> SERVER_AUTHORITY = Attributes.Key.create((String)"internal:server-authority");
    @Internal
    public static final Attributes.Key<InboundParcelablePolicy> INBOUND_PARCELABLE_POLICY = Attributes.Key.create((String)"internal:inbound-parcelable-policy");
    @Internal
    public static final int WIRE_FORMAT_VERSION = 1;
    @Internal
    public static final int EARLIEST_SUPPORTED_WIRE_FORMAT_VERSION = 1;
    private static final int TRANSACTION_BYTES_WINDOW = 131072;
    private static final int TRANSACTION_BYTES_WINDOW_FORCE_ACK = 16384;
    @Internal
    public static final int SETUP_TRANSPORT = 1;
    @Internal
    public static final int SHUTDOWN_TRANSPORT = 2;
    static final int ACKNOWLEDGE_BYTES = 3;
    private static final int PING = 4;
    private static final int PING_RESPONSE = 5;
    private static final int RESERVED_TRANSACTIONS = 1000;
    private static final int FIRST_CALL_ID = 1001;
    private static final int LAST_CALL_ID = 0xFFFFFF;
    private final ObjectPool<ScheduledExecutorService> executorServicePool;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogId logId;
    private final LeakSafeOneWayBinder incomingBinder;
    protected final ConcurrentHashMap<Integer, Inbound<?>> ongoingCalls;
    @GuardedBy(value="this")
    private final LinkedHashSet<Integer> callIdsToNotifyWhenReady = new LinkedHashSet();
    @GuardedBy(value="this")
    protected Attributes attributes;
    @GuardedBy(value="this")
    private TransportState transportState = TransportState.NOT_STARTED;
    @Nullable
    @GuardedBy(value="this")
    protected Status shutdownStatus;
    @Nullable
    private OneWayBinderProxy outgoingBinder;
    private final FlowController flowController;
    private final AtomicLong numIncomingBytes;
    private long acknowledgedIncomingBytes;

    private BinderTransport(ObjectPool<ScheduledExecutorService> executorServicePool, Attributes attributes, InternalLogId logId) {
        this.executorServicePool = executorServicePool;
        this.attributes = attributes;
        this.logId = logId;
        this.scheduledExecutorService = (ScheduledExecutorService)executorServicePool.getObject();
        this.incomingBinder = new LeakSafeOneWayBinder(this);
        this.ongoingCalls = new ConcurrentHashMap();
        this.flowController = new FlowController(131072);
        this.numIncomingBytes = new AtomicLong();
    }

    public final ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public final ListenableFuture<InternalChannelz.SocketStats> getStats() {
        return Futures.immediateFuture(null);
    }

    public final InternalLogId getLogId() {
        return this.logId;
    }

    public final synchronized Attributes getAttributes() {
        return this.attributes;
    }

    final boolean isReady() {
        return !this.flowController.isTransmitWindowFull();
    }

    abstract void notifyShutdown(Status var1);

    abstract void notifyTerminated();

    void releaseExecutors() {
        this.executorServicePool.returnObject((Object)this.scheduledExecutorService);
    }

    @GuardedBy(value="this")
    boolean inState(TransportState transportState) {
        return this.transportState == transportState;
    }

    @GuardedBy(value="this")
    boolean isShutdown() {
        return this.inState(TransportState.SHUTDOWN) || this.inState(TransportState.SHUTDOWN_TERMINATED);
    }

    @GuardedBy(value="this")
    final void setState(TransportState newState) {
        BinderTransport.checkTransition(this.transportState, newState);
        this.transportState = newState;
    }

    @GuardedBy(value="this")
    protected boolean setOutgoingBinder(OneWayBinderProxy binder) {
        this.outgoingBinder = binder;
        try {
            binder.getDelegate().linkToDeath((IBinder.DeathRecipient)this, 0);
            return true;
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public synchronized void binderDied() {
        this.shutdownInternal(Status.UNAVAILABLE.withDescription("binderDied"), true);
    }

    @GuardedBy(value="this")
    final void shutdownInternal(Status shutdownStatus, boolean forceTerminate) {
        if (!this.isShutdown()) {
            this.shutdownStatus = shutdownStatus;
            this.setState(TransportState.SHUTDOWN);
            this.notifyShutdown(shutdownStatus);
        }
        if (!this.inState(TransportState.SHUTDOWN_TERMINATED) && (forceTerminate || this.ongoingCalls.isEmpty())) {
            this.incomingBinder.detach();
            this.setState(TransportState.SHUTDOWN_TERMINATED);
            this.sendShutdownTransaction();
            ArrayList calls = new ArrayList(this.ongoingCalls.values());
            this.ongoingCalls.clear();
            this.scheduledExecutorService.execute(() -> {
                Iterator iterator = calls.iterator();
                while (iterator.hasNext()) {
                    Inbound inbound;
                    Inbound inbound2 = inbound = (Inbound)iterator.next();
                    synchronized (inbound2) {
                        inbound.closeAbnormal(shutdownStatus);
                    }
                }
                this.notifyTerminated();
                this.releaseExecutors();
            });
        }
    }

    @GuardedBy(value="this")
    final void sendSetupTransaction() {
        this.sendSetupTransaction((OneWayBinderProxy)Preconditions.checkNotNull((Object)this.outgoingBinder));
    }

    @GuardedBy(value="this")
    final void sendSetupTransaction(OneWayBinderProxy iBinder) {
        try (ParcelHolder parcel = ParcelHolder.obtain();){
            parcel.get().writeInt(1);
            parcel.get().writeStrongBinder((IBinder)this.incomingBinder);
            iBinder.transact(1, parcel);
        }
        catch (RemoteException re) {
            this.shutdownInternal(BinderTransport.statusFromRemoteException(re), true);
        }
    }

    @GuardedBy(value="this")
    private final void sendShutdownTransaction() {
        if (this.outgoingBinder != null) {
            try {
                this.outgoingBinder.getDelegate().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try (ParcelHolder parcel = ParcelHolder.obtain();){
                parcel.get().writeInt(0);
                this.outgoingBinder.transact(2, parcel);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    protected synchronized void sendPing(int id) throws StatusException {
        if (this.inState(TransportState.SHUTDOWN_TERMINATED)) {
            throw this.shutdownStatus.asException();
        }
        if (this.outgoingBinder == null) {
            throw Status.FAILED_PRECONDITION.withDescription("Transport not ready.").asException();
        }
        try (ParcelHolder parcel = ParcelHolder.obtain();){
            parcel.get().writeInt(id);
            this.outgoingBinder.transact(4, parcel);
        }
        catch (RemoteException re) {
            throw BinderTransport.statusFromRemoteException(re).asException();
        }
    }

    protected void unregisterInbound(Inbound<?> inbound) {
        this.unregisterCall(inbound.callId);
    }

    final void unregisterCall(int callId) {
        boolean removed;
        boolean bl = removed = this.ongoingCalls.remove(callId) != null;
        if (removed && this.ongoingCalls.isEmpty()) {
            this.scheduledExecutorService.execute(() -> {
                BinderTransport binderTransport = this;
                synchronized (binderTransport) {
                    if (this.inState(TransportState.SHUTDOWN)) {
                        this.shutdownInternal(this.shutdownStatus, true);
                    }
                }
            });
        }
    }

    final void sendTransaction(int callId, ParcelHolder parcel) throws StatusException {
        int dataSize = parcel.get().dataSize();
        try {
            this.outgoingBinder.transact(callId, parcel);
        }
        catch (RemoteException re) {
            throw BinderTransport.statusFromRemoteException(re).asException();
        }
        if (this.flowController.notifyBytesSent(dataSize)) {
            logger.log(Level.FINE, "transmit window now full " + this);
        }
    }

    final void sendOutOfBandClose(int callId, Status status) {
        try (ParcelHolder parcel = ParcelHolder.obtain();){
            parcel.get().writeInt(0);
            int flags = TransactionUtils.writeStatus(parcel.get(), status);
            TransactionUtils.fillInFlags(parcel.get(), flags | 8);
            this.sendTransaction(callId, parcel);
        }
        catch (StatusException e) {
            logger.log(Level.WARNING, "Failed sending oob close transaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean handleTransaction(int code, Parcel parcel) {
        try {
            return this.handleTransactionInternal(code, parcel);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Terminating transport for uncaught Exception in transaction " + code, e);
            BinderTransport binderTransport = this;
            synchronized (binderTransport) {
                this.shutdownInternal(Status.INTERNAL.withCause((Throwable)e), true);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleTransactionInternal(int code, Parcel parcel) {
        long nib;
        if (code < 1001) {
            BinderTransport binderTransport = this;
            synchronized (binderTransport) {
                switch (code) {
                    case 3: {
                        this.handleAcknowledgedBytes(parcel.readLong());
                        break;
                    }
                    case 2: {
                        this.shutdownInternal(Status.UNAVAILABLE.withDescription("transport shutdown by peer"), true);
                        break;
                    }
                    case 1: {
                        this.handleSetupTransport(parcel);
                        break;
                    }
                    case 4: {
                        this.handlePing(parcel);
                        break;
                    }
                    case 5: {
                        this.handlePingResponse(parcel);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }
        int size = parcel.dataSize();
        Inbound<?> inbound = this.ongoingCalls.get(code);
        if (inbound == null) {
            BinderTransport binderTransport = this;
            synchronized (binderTransport) {
                Inbound<?> inbound2;
                if (!this.isShutdown() && (inbound = this.createInbound(code)) != null && (inbound2 = this.ongoingCalls.putIfAbsent(code, inbound)) != null) {
                    inbound = inbound2;
                }
            }
        }
        if (inbound != null) {
            inbound.handleTransaction(parcel);
        }
        if ((nib = this.numIncomingBytes.addAndGet(size)) - this.acknowledgedIncomingBytes > 16384L) {
            BinderTransport binderTransport = this;
            synchronized (binderTransport) {
                this.sendAcknowledgeBytes((OneWayBinderProxy)Preconditions.checkNotNull((Object)this.outgoingBinder));
            }
        }
        return true;
    }

    @Nullable
    @GuardedBy(value="this")
    protected Inbound<?> createInbound(int callId) {
        return null;
    }

    @GuardedBy(value="this")
    protected void handleSetupTransport(Parcel parcel) {
    }

    @GuardedBy(value="this")
    private final void handlePing(Parcel requestParcel) {
        int id = requestParcel.readInt();
        if (this.transportState == TransportState.READY) {
            try (ParcelHolder replyParcel = ParcelHolder.obtain();){
                replyParcel.get().writeInt(id);
                this.outgoingBinder.transact(5, replyParcel);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @GuardedBy(value="this")
    protected void handlePingResponse(Parcel parcel) {
    }

    @GuardedBy(value="this")
    private void sendAcknowledgeBytes(OneWayBinderProxy iBinder) {
        long n;
        this.acknowledgedIncomingBytes = n = this.numIncomingBytes.get();
        try (ParcelHolder parcel = ParcelHolder.obtain();){
            parcel.get().writeLong(n);
            iBinder.transact(3, parcel);
        }
        catch (RemoteException re) {
            this.shutdownInternal(BinderTransport.statusFromRemoteException(re), true);
        }
    }

    @GuardedBy(value="this")
    final void handleAcknowledgedBytes(long numBytes) {
        if (this.flowController.handleAcknowledgedBytes(numBytes)) {
            logger.log(Level.FINE, "handleAcknowledgedBytes: Transmit Window No-Longer Full. Unblock calls: " + this);
            this.callIdsToNotifyWhenReady.addAll(this.ongoingCalls.keySet());
            Iterator i = this.callIdsToNotifyWhenReady.iterator();
            while (this.isReady() && i.hasNext()) {
                Inbound<?> inbound = this.ongoingCalls.get(i.next());
                i.remove();
                if (inbound == null) continue;
                inbound.onTransportReady();
            }
        }
    }

    private static void checkTransition(TransportState current, TransportState next) {
        switch (next) {
            case SETUP: {
                Preconditions.checkState((current == TransportState.NOT_STARTED ? 1 : 0) != 0);
                break;
            }
            case READY: {
                Preconditions.checkState((current == TransportState.NOT_STARTED || current == TransportState.SETUP ? 1 : 0) != 0);
                break;
            }
            case SHUTDOWN: {
                Preconditions.checkState((current == TransportState.NOT_STARTED || current == TransportState.SETUP || current == TransportState.READY ? 1 : 0) != 0);
                break;
            }
            case SHUTDOWN_TERMINATED: {
                Preconditions.checkState((current == TransportState.SHUTDOWN ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @VisibleForTesting
    Map<Integer, Inbound<?>> getOngoingCalls() {
        return this.ongoingCalls;
    }

    private static Status statusFromRemoteException(RemoteException e) {
        if (e instanceof DeadObjectException || e instanceof TransactionTooLargeException) {
            return Status.UNAVAILABLE.withCause((Throwable)e);
        }
        return Status.INTERNAL.withCause((Throwable)e);
    }

    @Internal
    public static final class BinderServerTransport
    extends BinderTransport
    implements ServerTransport {
        private final List<ServerStreamTracer.Factory> streamTracerFactories;
        @Nullable
        private ServerTransportListener serverTransportListener;

        public BinderServerTransport(ObjectPool<ScheduledExecutorService> executorServicePool, Attributes attributes, List<ServerStreamTracer.Factory> streamTracerFactories, IBinder callbackBinder) {
            super(executorServicePool, attributes, BinderServerTransport.buildLogId(attributes));
            this.streamTracerFactories = streamTracerFactories;
            this.setOutgoingBinder(OneWayBinderProxy.wrap(callbackBinder, this.getScheduledExecutorService()));
        }

        public synchronized void setServerTransportListener(ServerTransportListener serverTransportListener) {
            this.serverTransportListener = serverTransportListener;
            if (this.isShutdown()) {
                this.setState(TransportState.SHUTDOWN_TERMINATED);
                this.notifyTerminated();
                this.releaseExecutors();
            } else {
                this.sendSetupTransaction();
                if (!this.isShutdown()) {
                    this.setState(TransportState.READY);
                    this.attributes = serverTransportListener.transportReady(this.attributes);
                }
            }
        }

        StatsTraceContext createStatsTraceContext(String methodName, Metadata headers) {
            return StatsTraceContext.newServerContext(this.streamTracerFactories, (String)methodName, (Metadata)headers);
        }

        synchronized Status startStream(ServerStream stream, String methodName, Metadata headers) {
            if (this.isShutdown()) {
                return Status.UNAVAILABLE.withDescription("transport is shutdown");
            }
            this.serverTransportListener.streamCreated(stream, methodName, headers);
            return Status.OK;
        }

        @Override
        @GuardedBy(value="this")
        public void notifyShutdown(Status status) {
        }

        @Override
        @GuardedBy(value="this")
        public void notifyTerminated() {
            if (this.serverTransportListener != null) {
                this.serverTransportListener.transportTerminated();
            }
        }

        public synchronized void shutdown() {
            this.shutdownInternal(Status.OK, false);
        }

        public synchronized void shutdownNow(Status reason) {
            this.shutdownInternal(reason, true);
        }

        @Override
        @Nullable
        @GuardedBy(value="this")
        protected Inbound<?> createInbound(int callId) {
            return new Inbound.ServerInbound(this, this.attributes, callId);
        }

        private static InternalLogId buildLogId(Attributes attributes) {
            return InternalLogId.allocate(BinderServerTransport.class, (String)("from " + attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)));
        }
    }

    @ThreadSafe
    @Internal
    public static final class BinderClientTransport
    extends BinderTransport
    implements ConnectionClientTransport,
    Bindable.Observer {
        private final ObjectPool<? extends Executor> offloadExecutorPool;
        private final Executor offloadExecutor;
        private final SecurityPolicy securityPolicy;
        private final Bindable serviceBinding;
        private final AtomicInteger numInUseStreams;
        private final PingTracker pingTracker;
        @Nullable
        private ManagedClientTransport.Listener clientTransportListener;
        @GuardedBy(value="this")
        private int latestCallId = 1001;

        public BinderClientTransport(Context sourceContext, BinderChannelCredentials channelCredentials, AndroidComponentAddress targetAddress, @Nullable UserHandle targetUserHandle, BindServiceFlags bindServiceFlags, Executor mainThreadExecutor, ObjectPool<ScheduledExecutorService> executorServicePool, ObjectPool<? extends Executor> offloadExecutorPool, SecurityPolicy securityPolicy, InboundParcelablePolicy inboundParcelablePolicy, Attributes eagAttrs) {
            super(executorServicePool, BinderClientTransport.buildClientAttributes(eagAttrs, sourceContext, targetAddress, inboundParcelablePolicy), BinderClientTransport.buildLogId(sourceContext, targetAddress));
            this.offloadExecutorPool = offloadExecutorPool;
            this.securityPolicy = securityPolicy;
            this.offloadExecutor = (Executor)offloadExecutorPool.getObject();
            this.numInUseStreams = new AtomicInteger();
            this.pingTracker = new PingTracker(Ticker.systemTicker(), id -> this.sendPing(id));
            this.serviceBinding = new ServiceBinding(mainThreadExecutor, sourceContext, channelCredentials, targetAddress.asBindIntent(), targetUserHandle, bindServiceFlags.toInteger(), this);
        }

        @Override
        void releaseExecutors() {
            super.releaseExecutors();
            this.offloadExecutorPool.returnObject((Object)this.offloadExecutor);
        }

        @Override
        public synchronized void onBound(IBinder binder) {
            this.sendSetupTransaction(OneWayBinderProxy.wrap(binder, this.offloadExecutor));
        }

        @Override
        public synchronized void onUnbound(Status reason) {
            this.shutdownInternal(reason, true);
        }

        @CheckReturnValue
        public synchronized Runnable start(ManagedClientTransport.Listener clientTransportListener) {
            this.clientTransportListener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)clientTransportListener);
            return () -> {
                BinderClientTransport binderClientTransport = this;
                synchronized (binderClientTransport) {
                    if (this.inState(TransportState.NOT_STARTED)) {
                        this.setState(TransportState.SETUP);
                        this.serviceBinding.bind();
                    }
                }
            };
        }

        public synchronized ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
            if (!this.inState(TransportState.READY)) {
                return BinderClientTransport.newFailingClientStream(this.isShutdown() ? this.shutdownStatus : Status.INTERNAL.withDescription("newStream() before transportReady()"), this.attributes, headers, tracers);
            }
            int callId = this.latestCallId++;
            if (this.latestCallId == 0xFFFFFF) {
                this.latestCallId = 1001;
            }
            StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext((ClientStreamTracer[])tracers, (Attributes)this.attributes, (Metadata)headers);
            Inbound.ClientInbound inbound = new Inbound.ClientInbound((BinderTransport)this, this.attributes, callId, GrpcUtil.shouldBeCountedForInUse((CallOptions)callOptions));
            if (this.ongoingCalls.putIfAbsent(callId, inbound) != null) {
                Status failure = Status.INTERNAL.withDescription("Clashing call IDs");
                this.shutdownInternal(failure, true);
                return BinderClientTransport.newFailingClientStream(failure, this.attributes, headers, tracers);
            }
            if (inbound.countsForInUse() && this.numInUseStreams.getAndIncrement() == 0) {
                this.clientTransportListener.transportInUse(true);
            }
            Outbound.ClientOutbound outbound = new Outbound.ClientOutbound(this, callId, method, headers, statsTraceContext);
            if (method.getType().clientSendsOneMessage()) {
                return new SingleMessageClientStream(inbound, outbound, this.attributes);
            }
            return new MultiMessageClientStream(inbound, outbound, this.attributes);
        }

        @Override
        protected void unregisterInbound(Inbound<?> inbound) {
            if (inbound.countsForInUse() && this.numInUseStreams.decrementAndGet() == 0) {
                this.clientTransportListener.transportInUse(false);
            }
            super.unregisterInbound(inbound);
        }

        public void ping(ClientTransport.PingCallback callback, Executor executor) {
            this.pingTracker.startPing(callback, executor);
        }

        public synchronized void shutdown(Status reason) {
            Preconditions.checkNotNull((Object)reason, (Object)"reason");
            this.shutdownInternal(reason, false);
        }

        public synchronized void shutdownNow(Status reason) {
            Preconditions.checkNotNull((Object)reason, (Object)"reason");
            this.shutdownInternal(reason, true);
        }

        @Override
        @GuardedBy(value="this")
        public void notifyShutdown(Status status) {
            this.clientTransportListener.transportShutdown(status);
        }

        @Override
        @GuardedBy(value="this")
        public void notifyTerminated() {
            if (this.numInUseStreams.getAndSet(0) > 0) {
                this.clientTransportListener.transportInUse(false);
            }
            this.serviceBinding.unbind();
            this.clientTransportListener.transportTerminated();
        }

        @Override
        @GuardedBy(value="this")
        protected void handleSetupTransport(Parcel parcel) {
            this.attributes = BinderClientTransport.setSecurityAttrs(this.attributes, Binder.getCallingUid());
            if (this.inState(TransportState.SETUP)) {
                int version = parcel.readInt();
                IBinder binder = parcel.readStrongBinder();
                if (version != 1) {
                    this.shutdownInternal(Status.UNAVAILABLE.withDescription("Wire format version mismatch"), true);
                } else if (binder == null) {
                    this.shutdownInternal(Status.UNAVAILABLE.withDescription("Malformed SETUP_TRANSPORT data"), true);
                } else {
                    this.offloadExecutor.execute(() -> this.checkSecurityPolicy(binder));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSecurityPolicy(IBinder binder) {
            Integer remoteUid;
            BinderClientTransport binderClientTransport = this;
            synchronized (binderClientTransport) {
                remoteUid = (Integer)this.attributes.get(REMOTE_UID);
            }
            Status authorization = remoteUid == null ? Status.UNAUTHENTICATED.withDescription("No remote UID available") : this.securityPolicy.checkAuthorization(remoteUid);
            binderClientTransport = this;
            synchronized (binderClientTransport) {
                if (this.inState(TransportState.SETUP)) {
                    if (!authorization.isOk()) {
                        this.shutdownInternal(authorization, true);
                    } else if (!this.setOutgoingBinder(OneWayBinderProxy.wrap(binder, this.offloadExecutor))) {
                        this.shutdownInternal(Status.UNAVAILABLE.withDescription("Failed to observe outgoing binder"), true);
                    } else if (!this.isShutdown()) {
                        this.setState(TransportState.READY);
                        this.clientTransportListener.transportReady();
                    }
                }
            }
        }

        @Override
        @GuardedBy(value="this")
        protected void handlePingResponse(Parcel parcel) {
            this.pingTracker.onPingResponse(parcel.readInt());
        }

        private static ClientStream newFailingClientStream(Status failure, Attributes attributes, Metadata headers, ClientStreamTracer[] tracers) {
            StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext((ClientStreamTracer[])tracers, (Attributes)attributes, (Metadata)headers);
            statsTraceContext.clientOutboundHeaders();
            return new FailingClientStream(failure, tracers);
        }

        private static InternalLogId buildLogId(Context sourceContext, AndroidComponentAddress targetAddress) {
            return InternalLogId.allocate(BinderClientTransport.class, (String)(sourceContext.getClass().getSimpleName() + "->" + targetAddress));
        }

        private static Attributes buildClientAttributes(Attributes eagAttrs, Context sourceContext, AndroidComponentAddress targetAddress, InboundParcelablePolicy inboundParcelablePolicy) {
            return Attributes.newBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.NONE).set(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS, (Object)eagAttrs).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)AndroidComponentAddress.forContext(sourceContext)).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)targetAddress).set(INBOUND_PARCELABLE_POLICY, (Object)inboundParcelablePolicy).build();
        }

        private static Attributes setSecurityAttrs(Attributes attributes, int uid) {
            return attributes.toBuilder().set(REMOTE_UID, (Object)uid).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)(uid == Process.myUid() ? SecurityLevel.PRIVACY_AND_INTEGRITY : SecurityLevel.INTEGRITY)).build();
        }
    }

    protected static enum TransportState {
        NOT_STARTED,
        SETUP,
        READY,
        SHUTDOWN,
        SHUTDOWN_TERMINATED;

    }
}

