/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Attributes;
import io.grpc.Internal;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.binder.internal.PendingAuthListener;
import io.grpc.internal.GrpcAttributes;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.CheckReturnValue;

public final class BinderTransportSecurity {
    private static final Attributes.Key<TransportAuthorizationState> TRANSPORT_AUTHORIZATION_STATE = Attributes.Key.create((String)"internal:transport-authorization-state");

    private BinderTransportSecurity() {
    }

    @Internal
    public static void installAuthInterceptor(ServerBuilder<?> serverBuilder, Executor executor) {
        serverBuilder.intercept((ServerInterceptor)new ServerAuthInterceptor(executor));
    }

    @Internal
    public static void attachAuthAttrs(Attributes.Builder builder, int remoteUid, ServerPolicyChecker serverPolicyChecker) {
        builder.set(TRANSPORT_AUTHORIZATION_STATE, (Object)new TransportAuthorizationState(remoteUid, serverPolicyChecker)).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY);
    }

    public static interface ShutdownListener {
        public void onServerShutdown();
    }

    public static interface ServerPolicyChecker {
        public ListenableFuture<Status> checkAuthorizationForServiceAsync(int var1, String var2);
    }

    private static final class TransportAuthorizationState {
        private final int uid;
        private final ServerPolicyChecker serverPolicyChecker;
        private final ConcurrentHashMap<String, ListenableFuture<Status>> serviceAuthorization;

        TransportAuthorizationState(int uid, ServerPolicyChecker serverPolicyChecker) {
            this.uid = uid;
            this.serverPolicyChecker = serverPolicyChecker;
            this.serviceAuthorization = new ConcurrentHashMap(8);
        }

        @CheckReturnValue
        ListenableFuture<Status> checkAuthorization(MethodDescriptor<?, ?> method) {
            ListenableFuture<Status> authorization;
            final String serviceName = method.getServiceName();
            boolean useCache = method.isSampledToLocalTracing();
            if (useCache && (authorization = this.serviceAuthorization.get(serviceName)) != null) {
                return authorization;
            }
            authorization = this.serverPolicyChecker.checkAuthorizationForServiceAsync(this.uid, serviceName);
            if (useCache) {
                this.serviceAuthorization.putIfAbsent(serviceName, authorization);
                Futures.addCallback(authorization, (FutureCallback)new FutureCallback<Status>(){

                    public void onSuccess(Status result) {
                    }

                    public void onFailure(Throwable t) {
                        serviceAuthorization.remove(serviceName, authorization);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
            return authorization;
        }
    }

    private static final class ServerAuthInterceptor
    implements ServerInterceptor {
        private final Executor executor;

        ServerAuthInterceptor(Executor executor) {
            this.executor = executor;
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            Status authStatus;
            block4: {
                ListenableFuture<Status> authStatusFuture = ((TransportAuthorizationState)call.getAttributes().get(TRANSPORT_AUTHORIZATION_STATE)).checkAuthorization(call.getMethodDescriptor());
                if (!authStatusFuture.isDone()) {
                    return this.newServerCallListenerForPendingAuthResult(authStatusFuture, call, headers, next);
                }
                try {
                    authStatus = (Status)Futures.getDone(authStatusFuture);
                }
                catch (CancellationException | ExecutionException e) {
                    authStatus = Status.INTERNAL.withCause((Throwable)e);
                    String message = e.getMessage();
                    if (message == null) break block4;
                    authStatus = authStatus.withDescription(message);
                }
            }
            if (authStatus.isOk()) {
                return next.startCall(call, headers);
            }
            call.close(authStatus, new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }

        private <ReqT, RespT> ServerCall.Listener<ReqT> newServerCallListenerForPendingAuthResult(ListenableFuture<Status> authStatusFuture, final ServerCall<ReqT, RespT> call, final Metadata headers, final ServerCallHandler<ReqT, RespT> next) {
            final PendingAuthListener listener = new PendingAuthListener();
            Futures.addCallback(authStatusFuture, (FutureCallback)new FutureCallback<Status>(){

                public void onSuccess(Status authStatus) {
                    if (!authStatus.isOk()) {
                        call.close(authStatus, new Metadata());
                        return;
                    }
                    listener.startCall(call, headers, next);
                }

                public void onFailure(Throwable t) {
                    call.close(Status.INTERNAL.withCause(t).withDescription("Authorization future failed"), new Metadata());
                }
            }, (Executor)this.executor);
            return listener;
        }
    }
}

