/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.binder.internal;

import io.grpc.Attributes;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.binder.internal.BinderTransport;
import io.grpc.binder.internal.Inbound;
import io.grpc.binder.internal.Outbound;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.StatsTraceContext;
import java.io.InputStream;
import javax.annotation.Nullable;

final class MultiMessageServerStream
implements ServerStream {
    private final Inbound.ServerInbound inbound;
    private final Outbound.ServerOutbound outbound;
    private final Attributes attributes;

    MultiMessageServerStream(Inbound.ServerInbound inbound, Outbound.ServerOutbound outbound, Attributes attributes) {
        this.inbound = inbound;
        this.outbound = outbound;
        this.attributes = attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(ServerStreamListener listener) {
        Inbound.ServerInbound serverInbound = this.inbound;
        synchronized (serverInbound) {
            this.inbound.init(this.outbound, listener);
        }
    }

    public boolean isReady() {
        return this.outbound.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(int numMessages) {
        Inbound.ServerInbound serverInbound = this.inbound;
        synchronized (serverInbound) {
            this.inbound.requestMessages(numMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaders(Metadata headers, boolean flush) {
        try {
            Outbound.ServerOutbound serverOutbound = this.outbound;
            synchronized (serverOutbound) {
                this.outbound.sendHeaders(headers);
            }
        }
        catch (StatusException se) {
            Inbound.ServerInbound serverInbound = this.inbound;
            synchronized (serverInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(InputStream message) {
        try {
            Outbound.ServerOutbound serverOutbound = this.outbound;
            synchronized (serverOutbound) {
                this.outbound.addMessage(message);
                this.outbound.send();
            }
        }
        catch (StatusException se) {
            Inbound.ServerInbound serverInbound = this.inbound;
            synchronized (serverInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Status status, Metadata trailers) {
        try {
            Object object = this.outbound;
            synchronized (object) {
                this.outbound.sendClose(status, trailers);
            }
            object = this.inbound;
            synchronized (object) {
                this.inbound.onCloseSent(status);
            }
        }
        catch (StatusException se) {
            Inbound.ServerInbound serverInbound = this.inbound;
            synchronized (serverInbound) {
                this.inbound.closeAbnormal(se.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Status status) {
        Inbound.ServerInbound serverInbound = this.inbound;
        synchronized (serverInbound) {
            this.inbound.closeOnCancel(status);
        }
    }

    public StatsTraceContext statsTraceContext() {
        return this.outbound.getStatsTraceContext();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getAuthority() {
        return (String)this.attributes.get(BinderTransport.SERVER_AUTHORITY);
    }

    public String toString() {
        return "MultiMessageServerStream[" + this.inbound + "/" + this.outbound + "]";
    }

    public final void flush() {
    }

    public final void setCompressor(Compressor compressor) {
    }

    public final void setMessageCompression(boolean enable) {
    }

    public void setDecompressor(Decompressor decompressor) {
    }

    public void optimizeForDirectExecutor() {
    }

    public int streamId() {
        return -1;
    }
}

